/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.examples.walkers;

import io.github.springwolf.asyncapi.v3.model.ReferenceUtil;
import io.github.springwolf.core.asyncapi.components.examples.walkers.ExampleValueGenerator;
import io.github.springwolf.core.asyncapi.components.examples.walkers.PropertyExample;
import io.github.springwolf.core.asyncapi.components.examples.walkers.SchemaWalker;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultSchemaWalker<T, R>
implements SchemaWalker<R> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSchemaWalker.class);
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    Boolean DEFAULT_BOOLEAN_EXAMPLE = true;
    String DEFAULT_MAP_KEY_EXAMPLE = "key";
    String DEFAULT_STRING_EXAMPLE = "string";
    Integer DEFAULT_INTEGER_EXAMPLE = 0;
    Double DEFAULT_NUMBER_EXAMPLE = 1.1;
    String DEFAULT_DATE_EXAMPLE = "2015-07-20";
    String DEFAULT_DATE_TIME_EXAMPLE = "2015-07-20T15:49:04-07:00";
    String DEFAULT_PASSWORD_EXAMPLE = "string-password";
    String DEFAULT_BYTE_EXAMPLE = "YmFzZTY0LWV4YW1wbGU=";
    String DEFAULT_BINARY_EXAMPLE = "0111010001100101011100110111010000101101011000100110100101101110011000010110010001111001";
    String DEFAULT_EMAIL_EXAMPLE = "example@example.com";
    String DEFAULT_UUID_EXAMPLE = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
    private final ExampleValueGenerator<T, R> exampleValueGenerator;

    @Override
    public boolean canHandle(String contentType) {
        return this.exampleValueGenerator.canHandle(contentType);
    }

    @Override
    public R fromSchema(Schema schema, Map<String, Schema> definitions) {
        this.exampleValueGenerator.initialize();
        try {
            Optional<String> schemaName = this.exampleValueGenerator.lookupSchemaName(schema);
            T generatedExample = this.buildExample(schemaName, schema, definitions, new HashSet<Schema>()).orElseThrow(() -> new SchemaWalker.ExampleGeneratingException("Something went wrong"));
            return this.exampleValueGenerator.prepareForSerialization(schema, generatedExample);
        }
        catch (SchemaWalker.ExampleGeneratingException ex) {
            log.info("Failed to build example for schema: {}", (Object)ex.getMessage(), (Object)ex);
            return null;
        }
    }

    private Optional<T> buildExample(Optional<String> name, Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        log.debug("Building example for schema {}", (Object)schema);
        Optional<T> exampleValue = this.getExampleFromSchemaAnnotation(name, schema);
        if (exampleValue.isPresent()) {
            return exampleValue;
        }
        if (visited.contains(schema)) {
            return this.exampleValueGenerator.createEmptyObjectExample();
        }
        visited.add(schema);
        Optional<T> example = this.buildExampleFromUnvisitedSchema(name, schema, definitions, visited);
        visited.remove(schema);
        return example;
    }

    private Optional<T> getExampleFromSchemaAnnotation(Optional<String> fieldName, Schema schema) {
        return this.getExampleValueFromSchemaAnnotation(fieldName, schema, schema.getExample()).or(() -> this.getExampleValueFromSchemaAnnotation(fieldName, schema, schema.getDefault()));
    }

    private Optional<T> getExampleValueFromSchemaAnnotation(Optional<String> fieldName, Schema schema, Object exampleValue) {
        String formatted;
        StringSchema additionalPropertiesSchema;
        Object exampleValueString;
        if (exampleValue == null) {
            return Optional.empty();
        }
        T processedExample = this.exampleValueGenerator.getExampleOrNull(fieldName, schema, exampleValue);
        if (processedExample != null) {
            return Optional.of(processedExample);
        }
        Object additionalProperties = schema.getAdditionalProperties();
        if (additionalProperties instanceof StringSchema && (exampleValueString = (additionalPropertiesSchema = (StringSchema)additionalProperties).getExample()) != null) {
            return Optional.ofNullable(this.exampleValueGenerator.createRaw(exampleValueString));
        }
        if (exampleValue instanceof Map) {
            return Optional.empty();
        }
        if (exampleValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)exampleValue;
            return this.exampleValueGenerator.createBooleanExample(booleanValue, schema);
        }
        if (exampleValue instanceof Number) {
            Number numberValue = (Number)exampleValue;
            double doubleValue = numberValue.doubleValue();
            if (doubleValue == (double)((int)doubleValue)) {
                return this.exampleValueGenerator.createIntegerExample((int)doubleValue, schema);
            }
            return this.exampleValueGenerator.createDoubleExample(doubleValue, schema);
        }
        if (exampleValue instanceof Date) {
            Date exampleDate = (Date)exampleValue;
            formatted = ISO_DATE_FORMAT.format(exampleDate);
            return this.exampleValueGenerator.createStringExample(formatted, schema);
        }
        if (exampleValue instanceof OffsetDateTime) {
            OffsetDateTime exampleOffsetDateTime = (OffsetDateTime)exampleValue;
            formatted = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(exampleOffsetDateTime);
            return this.exampleValueGenerator.createStringExample(formatted, schema);
        }
        try {
            return this.exampleValueGenerator.createStringExample(exampleValue.toString(), schema);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to convert example to JSON: {}", exampleValue, (Object)ex);
            return this.exampleValueGenerator.createEmptyObjectExample();
        }
    }

    private Optional<T> buildExampleFromUnvisitedSchema(Optional<String> name, Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        String type;
        Optional<Schema<?>> resolvedSchema = this.resolveSchemaFromRef(schema, definitions);
        if (resolvedSchema.isPresent()) {
            return this.buildExample(name, resolvedSchema.get(), definitions, visited);
        }
        Optional<T> composedSchemaExample = this.buildFromComposedSchema(name, schema, definitions, visited);
        if (composedSchemaExample.isPresent()) {
            return composedSchemaExample;
        }
        return switch (type = schema.getType()) {
            case "array" -> this.buildArrayExample(schema, definitions, visited);
            case "boolean" -> this.exampleValueGenerator.createBooleanExample(this.DEFAULT_BOOLEAN_EXAMPLE, schema);
            case "integer" -> this.exampleValueGenerator.createIntegerExample(this.DEFAULT_INTEGER_EXAMPLE, schema);
            case "number" -> this.exampleValueGenerator.createDoubleExample(this.DEFAULT_NUMBER_EXAMPLE, schema);
            case "object" -> this.buildFromObjectSchema(name, schema, definitions, visited);
            case "string" -> this.buildFromStringSchema(schema);
            default -> this.exampleValueGenerator.createUnknownSchemaStringTypeExample(type);
        };
    }

    private Optional<T> buildArrayExample(Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        Schema arrayItemSchema = this.resolveSchemaFromRef(schema.getItems(), definitions).orElse(schema.getItems());
        Optional<String> arrayName = this.exampleValueGenerator.lookupSchemaName(schema);
        return this.exampleValueGenerator.lookupSchemaName(arrayItemSchema).or(() -> arrayName).flatMap(arrayItemName -> this.buildExample(Optional.of(arrayItemName), arrayItemSchema, definitions, visited)).map(arrayItem -> this.exampleValueGenerator.createArrayExample(arrayName, arrayItem));
    }

    private Optional<T> buildFromStringSchema(Schema schema) {
        String firstEnumValue = this.getFirstEnumValue(schema);
        if (firstEnumValue != null) {
            return this.exampleValueGenerator.createEnumExample(firstEnumValue, schema);
        }
        String format = schema.getFormat();
        if (format == null) {
            return this.exampleValueGenerator.createStringExample(this.DEFAULT_STRING_EXAMPLE, schema);
        }
        return switch (format) {
            case "date" -> this.exampleValueGenerator.createStringExample(this.DEFAULT_DATE_EXAMPLE, schema);
            case "date-time" -> this.exampleValueGenerator.createStringExample(this.DEFAULT_DATE_TIME_EXAMPLE, schema);
            case "email" -> this.exampleValueGenerator.createStringExample(this.DEFAULT_EMAIL_EXAMPLE, schema);
            case "password" -> this.exampleValueGenerator.createStringExample(this.DEFAULT_PASSWORD_EXAMPLE, schema);
            case "byte" -> this.exampleValueGenerator.createStringExample(this.DEFAULT_BYTE_EXAMPLE, schema);
            case "binary" -> this.exampleValueGenerator.createStringExample(this.DEFAULT_BINARY_EXAMPLE, schema);
            case "uuid" -> this.exampleValueGenerator.createStringExample(this.DEFAULT_UUID_EXAMPLE, schema);
            default -> this.exampleValueGenerator.createUnknownSchemaStringFormatExample(format);
        };
    }

    private String getFirstEnumValue(Schema schema) {
        Optional firstEnumEntry;
        List enums = schema.getEnum();
        if (enums != null && (firstEnumEntry = enums.stream().findFirst()).isPresent()) {
            return (String)firstEnumEntry.get();
        }
        return null;
    }

    private Optional<T> buildFromComposedSchema(Optional<String> name, Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        List schemasAllOf = schema.getAllOf();
        List schemasAnyOf = schema.getAnyOf();
        List schemasOneOf = schema.getOneOf();
        if (!CollectionUtils.isEmpty((Collection)schemasAllOf)) {
            return this.buildFromObjectSchemaWithAllOf(name, schemasAllOf, definitions, visited);
        }
        if (!CollectionUtils.isEmpty((Collection)schemasAnyOf)) {
            return this.buildExample(name, (Schema)schemasAnyOf.get(0), definitions, visited);
        }
        if (!CollectionUtils.isEmpty((Collection)schemasOneOf)) {
            return this.buildExample(name, (Schema)schemasOneOf.get(0), definitions, visited);
        }
        return Optional.empty();
    }

    private Optional<T> buildFromObjectSchema(Optional<String> name, Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        Map properties = schema.getProperties();
        Object additionalProperties = schema.getAdditionalProperties();
        Optional<T> exampleValue = properties != null ? this.buildFromObjectSchemaWithProperties(name, properties, definitions, visited) : (schema instanceof MapSchema && additionalProperties instanceof Schema ? this.buildMapExample(name, (Schema)additionalProperties, definitions, visited) : this.exampleValueGenerator.createEmptyObjectExample());
        return exampleValue;
    }

    private Optional<T> buildMapExample(Optional<String> name, Schema additionalProperties, Map<String, Schema> definitions, Set<Schema> visited) {
        T object = this.exampleValueGenerator.startObject(name);
        Map<String, Schema> mapProperties = Map.of(this.DEFAULT_MAP_KEY_EXAMPLE, additionalProperties);
        this.exampleValueGenerator.addPropertyExamples(object, this.buildPropertyExampleListFromSchema(mapProperties, definitions, visited));
        this.exampleValueGenerator.endObject();
        return Optional.of(object);
    }

    private Optional<T> buildFromObjectSchemaWithProperties(Optional<String> name, Map<String, Schema> properties, Map<String, Schema> definitions, Set<Schema> visited) {
        T object = this.exampleValueGenerator.startObject(name);
        this.exampleValueGenerator.addPropertyExamples(object, this.buildPropertyExampleListFromSchema(properties, definitions, visited));
        this.exampleValueGenerator.endObject();
        return Optional.of(object);
    }

    private Optional<T> buildFromObjectSchemaWithAllOf(Optional<String> name, List<Schema> schemasAllOf, Map<String, Schema> definitions, Set<Schema> visited) {
        T object = this.exampleValueGenerator.startObject(name);
        this.exampleValueGenerator.addPropertyExamples(object, this.buildPropertyExampleListFromSchemas(schemasAllOf, definitions, visited));
        this.exampleValueGenerator.endObject();
        return Optional.of(object);
    }

    private List<PropertyExample<T>> buildPropertyExampleListFromSchema(Map<String, Schema> properties, Map<String, Schema> definitions, Set<Schema> visited) {
        return properties.entrySet().stream().map(propertySchema -> {
            String propertyKey = this.exampleValueGenerator.lookupSchemaName((Schema)propertySchema.getValue()).orElse((String)propertySchema.getKey());
            Optional<Object> propertyValue = this.buildExample(Optional.of(propertyKey), (Schema)propertySchema.getValue(), definitions, visited);
            return propertyValue.map(optionalElem -> new PropertyExample<Object>(propertyKey, optionalElem)).orElse(null);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(PropertyExample::name)).toList();
    }

    private List<PropertyExample<T>> buildPropertyExampleListFromSchemas(List<Schema> schemas, Map<String, Schema> definitions, Set<Schema> visited) {
        return schemas.stream().map(schema -> this.resolveSchemaFromRef((Schema)schema, definitions).orElse((Schema<?>)schema)).map(Schema::getProperties).filter(Objects::nonNull).flatMap(propertiesFromSchema -> this.buildPropertyExampleListFromSchema((Map<String, Schema>)propertiesFromSchema, definitions, visited).stream()).sorted(Comparator.comparing(PropertyExample::name)).toList();
    }

    private Optional<Schema<?>> resolveSchemaFromRef(Schema schema, Map<String, Schema> definitions) {
        String ref = schema.get$ref();
        if (ref != null) {
            String schemaName = ReferenceUtil.getLastSegment((String)ref);
            Schema resolvedSchema = definitions.get(schemaName);
            if (resolvedSchema == null) {
                throw new SchemaWalker.ExampleGeneratingException(String.format("Missing schema (name = %s) during example generation", schemaName));
            }
            return Optional.of(resolvedSchema);
        }
        return Optional.empty();
    }

    @Generated
    public DefaultSchemaWalker(ExampleValueGenerator<T, R> exampleValueGenerator) {
        this.exampleValueGenerator = exampleValueGenerator;
    }
}

