/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.postprocessors;

import io.github.springwolf.asyncapi.v3.model.ReferenceUtil;
import io.github.springwolf.core.asyncapi.components.postprocessors.SchemasPostProcessor;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class AvroSchemaPostProcessor
implements SchemasPostProcessor {
    private static final String SCHEMA_AVRO_PREFIX = "org.apache.avro.";
    private static final String SCHEMA_PROPERTY = "schema";
    private static final String SPECIFIC_DATA_PROPERTY = "specificData";
    private static final String SCHEMA_REF = "org.apache.avro.Schema";
    private static final String SPECIFIC_DAT_REF = "org.apache.avro.specific.SpecificData";

    @Override
    public void process(Schema schema, Map<String, Schema> definitions, String contentType) {
        this.removeSchemas(definitions);
        LinkedList<Schema> queue = new LinkedList<Schema>(List.of(schema));
        HashSet<Schema> visited = new HashSet<Schema>();
        while (!queue.isEmpty()) {
            Schema currentSchema = (Schema)queue.pop();
            if (visited.contains(currentSchema)) continue;
            visited.add(currentSchema);
            this.processRefSchema(currentSchema, queue, definitions);
            this.processProperties(currentSchema, queue);
        }
    }

    private void processRefSchema(Schema schema, Deque<Schema> queue, Map<String, Schema> definitions) {
        String schemaName;
        Schema refedSchema;
        if (schema.get$ref() != null && (refedSchema = definitions.get(schemaName = ReferenceUtil.getLastSegment((String)schema.get$ref()))) != null) {
            queue.add(refedSchema);
        }
    }

    private void processProperties(Schema schema, Deque<Schema> queue) {
        Map properties = schema.getProperties();
        if (properties != null) {
            Schema schemaPropertySchema = properties.getOrDefault(SCHEMA_PROPERTY, null);
            Schema specificDataPropertySchema = properties.getOrDefault(SPECIFIC_DATA_PROPERTY, null);
            if (schemaPropertySchema != null && specificDataPropertySchema != null && StringUtils.endsWithIgnoreCase((String)schemaPropertySchema.get$ref(), (String)SCHEMA_REF) && StringUtils.endsWithIgnoreCase((String)specificDataPropertySchema.get$ref(), (String)SPECIFIC_DAT_REF)) {
                properties.remove(SCHEMA_PROPERTY);
                properties.remove(SPECIFIC_DATA_PROPERTY);
            }
            properties.forEach((key, value) -> queue.add((Schema)value));
        }
    }

    private void removeSchemas(Map<String, Schema> definitions) {
        definitions.entrySet().removeIf(entry -> StringUtils.startsWithIgnoreCase((String)((String)entry.getKey()), (String)SCHEMA_AVRO_PREFIX));
    }
}

