/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.bindings.channels;

import io.github.springwolf.core.asyncapi.annotations.AsyncChannelBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.ChannelBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.ProcessedChannelBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public abstract class AbstractChannelBindingProcessor<A>
implements ChannelBindingProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelBindingProcessor.class);
    private final StringValueResolver stringValueResolver;
    private final Class<A> specificAnnotationClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public Optional<ProcessedChannelBinding> process(AnnotatedElement annotatedElement) {
        return Arrays.stream(annotatedElement.getAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(AsyncChannelBinding.class)).flatMap(this::tryCast).findAny().map(this::mapToChannelBinding);
    }

    private Stream<A> tryCast(Annotation obj) {
        try {
            return Stream.of(this.specificAnnotationClazz.cast(obj));
        }
        catch (ClassCastException ex) {
            log.trace("Method has multiple bindings defined.", (Throwable)ex);
            return Stream.empty();
        }
    }

    protected abstract ProcessedChannelBinding mapToChannelBinding(A var1);

    protected String resolveOrNull(String stringValue) {
        return StringUtils.hasText((String)stringValue) ? this.stringValueResolver.resolveStringValue(stringValue) : null;
    }

    @Generated
    public AbstractChannelBindingProcessor(StringValueResolver stringValueResolver) {
        this.stringValueResolver = stringValueResolver;
    }
}

