/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.channels.annotations;

import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.scanners.channels.ChannelsInClassScanner;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.channel.SpringAnnotationChannelService;
import io.github.springwolf.core.asyncapi.scanners.common.headers.HeaderClassExtractor;
import io.github.springwolf.core.asyncapi.scanners.common.message.SpringAnnotationMessageService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadMethodService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationMethodLevelChannelsScanner<MethodAnnotation extends Annotation>
implements ChannelsInClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationMethodLevelChannelsScanner.class);
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final PayloadMethodService payloadMethodService;
    private final HeaderClassExtractor headerClassExtractor;
    private final SpringAnnotationChannelService<MethodAnnotation> springAnnotationChannelService;
    private final SpringAnnotationMessageService<MethodAnnotation> springAnnotationMessageService;

    @Override
    public List<ChannelObject> scan(Class<?> clazz) {
        return AnnotationScannerUtil.findAnnotatedMethods(clazz, this.methodAnnotationClass).map(this::mapMethodToChannel).toList();
    }

    private ChannelObject mapMethodToChannel(MethodAndAnnotation<MethodAnnotation> method) {
        MethodAnnotation annotation = AnnotationUtil.findFirstAnnotationOrThrow(this.methodAnnotationClass, method.method());
        PayloadSchemaObject payloadSchema = this.payloadMethodService.extractSchema(method.method());
        SchemaObject headerSchema = this.headerClassExtractor.extractHeader(method.method(), payloadSchema);
        MessageObject message = this.springAnnotationMessageService.buildMessage(annotation, payloadSchema, headerSchema);
        Map<String, MessageReference> messages = Map.of(message.getMessageId(), MessageReference.toComponentMessage((MessageObject)message));
        return this.springAnnotationChannelService.buildChannel(annotation, messages);
    }

    @Generated
    public SpringAnnotationMethodLevelChannelsScanner(Class<MethodAnnotation> methodAnnotationClass, PayloadMethodService payloadMethodService, HeaderClassExtractor headerClassExtractor, SpringAnnotationChannelService<MethodAnnotation> springAnnotationChannelService, SpringAnnotationMessageService<MethodAnnotation> springAnnotationMessageService) {
        this.methodAnnotationClass = methodAnnotationClass;
        this.payloadMethodService = payloadMethodService;
        this.headerClassExtractor = headerClassExtractor;
        this.springAnnotationChannelService = springAnnotationChannelService;
        this.springAnnotationMessageService = springAnnotationMessageService;
    }
}

