/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.classes.spring.annotations;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.TypeFilter;

public abstract class ClassScannerUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassScannerUtil.class);

    public static List<Class<?>> getClasses(String basePackages, TypeFilter filter, Environment environment) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false, environment);
        provider.addIncludeFilter(filter);
        return Arrays.stream(basePackages.replaceAll("\\s", "").split(",")).flatMap(basePackage -> provider.findCandidateComponents(basePackage).stream().map(BeanDefinition::getBeanClassName).map(ClassScannerUtil::getClass).filter(Optional::isPresent).map(Optional::get)).collect(Collectors.toList());
    }

    private static Optional<Class<?>> getClass(String className) {
        try {
            log.debug("Found candidate class: {}", (Object)className);
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            log.warn("Failed to get class for name: {}", (Object)className);
            return Optional.empty();
        }
    }
}

