/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.annotation;

import io.github.springwolf.asyncapi.v3.bindings.ChannelBinding;
import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.annotations.AsyncMessage;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.ChannelBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.ProcessedChannelBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.MessageBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.ProcessedMessageBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.OperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.ProcessedOperationBinding;
import io.github.springwolf.core.asyncapi.scanners.common.headers.AsyncHeadersNotDocumented;
import io.github.springwolf.core.asyncapi.scanners.common.headers.AsyncHeadersNotUsed;
import io.github.springwolf.core.asyncapi.scanners.common.headers.HeaderSchemaObjectMerger;
import io.github.springwolf.core.asyncapi.scanners.common.utils.TextUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class AsyncAnnotationUtil {
    private AsyncAnnotationUtil() {
    }

    public static SchemaObject getAsyncHeaders(AsyncOperation op, StringValueResolver stringValueResolver) {
        AsyncOperation.Headers headers = op.headers();
        if (headers.values().length == 0) {
            if (headers.notUsed()) {
                return AsyncHeadersNotUsed.NOT_USED;
            }
            return AsyncHeadersNotDocumented.NOT_DOCUMENTED;
        }
        String headerSchemaTitle = StringUtils.hasText((String)headers.schemaName()) ? headers.schemaName() : HeaderSchemaObjectMerger.generateHeaderSchemaName(headers);
        String headerDescription = StringUtils.hasText((String)headers.description()) ? stringValueResolver.resolveStringValue(headers.description()) : null;
        SchemaObject headerSchema = new SchemaObject();
        headerSchema.setType("object");
        headerSchema.setTitle(headerSchemaTitle);
        headerSchema.setDescription(headerDescription);
        headerSchema.setProperties(new HashMap());
        Arrays.stream(headers.values()).collect(Collectors.groupingBy(AsyncOperation.Headers.Header::name)).forEach((headerName, headersValues) -> {
            String propertyName = stringValueResolver.resolveStringValue(headerName);
            SchemaObject property = new SchemaObject();
            property.setType("string");
            property.setTitle(propertyName);
            property.setDescription(AsyncAnnotationUtil.getDescription(headersValues, stringValueResolver));
            List<String> values = AsyncAnnotationUtil.getHeaderValues(headersValues, stringValueResolver);
            property.setExamples(new ArrayList<String>(values));
            property.setEnumValues(values);
            headerSchema.getProperties().put(propertyName, property);
        });
        return headerSchema;
    }

    private static List<String> getHeaderValues(List<AsyncOperation.Headers.Header> value, StringValueResolver stringValueResolver) {
        return value.stream().map(AsyncOperation.Headers.Header::value).filter(StringUtils::hasText).map(arg_0 -> ((StringValueResolver)stringValueResolver).resolveStringValue(arg_0)).sorted().toList();
    }

    private static String getDescription(List<AsyncOperation.Headers.Header> value, StringValueResolver stringValueResolver) {
        return value.stream().map(AsyncOperation.Headers.Header::description).map(arg_0 -> ((StringValueResolver)stringValueResolver).resolveStringValue(arg_0)).filter(StringUtils::hasText).sorted().findFirst().orElse(null);
    }

    public static Map<String, OperationBinding> processOperationBindingFromAnnotation(Method method, List<OperationBindingProcessor> operationBindingProcessors) {
        return operationBindingProcessors.stream().map(operationBindingProcessor -> operationBindingProcessor.process(method)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedOperationBinding::getType, ProcessedOperationBinding::getBinding, (e1, e2) -> e1));
    }

    public static Map<String, MessageBinding> processMessageBindingFromAnnotation(AnnotatedElement annotatedElement, List<MessageBindingProcessor> messageBindingProcessors) {
        return messageBindingProcessors.stream().map(messageBindingProcessor -> messageBindingProcessor.process(annotatedElement)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedMessageBinding::getType, ProcessedMessageBinding::getBinding, (e1, e2) -> e1));
    }

    public static void processAsyncMessageAnnotation(MessageObject.MessageObjectBuilder messageBuilder, AsyncMessage asyncMessage, StringValueResolver stringValueResolver) {
        String annotationTitle;
        String annotationName;
        String annotationMessageId;
        String annotationMessageDescription = stringValueResolver.resolveStringValue(asyncMessage.description());
        if (StringUtils.hasText((String)annotationMessageDescription)) {
            annotationMessageDescription = TextUtils.trimIndent(annotationMessageDescription);
            messageBuilder.description(annotationMessageDescription);
        }
        if (StringUtils.hasText((String)(annotationMessageId = stringValueResolver.resolveStringValue(asyncMessage.messageId())))) {
            messageBuilder.messageId(annotationMessageId);
        }
        if (StringUtils.hasText((String)(annotationName = stringValueResolver.resolveStringValue(asyncMessage.name())))) {
            messageBuilder.name(annotationName);
        }
        if (StringUtils.hasText((String)(annotationTitle = stringValueResolver.resolveStringValue(asyncMessage.title())))) {
            messageBuilder.title(annotationTitle);
        }
        if (StringUtils.hasText((String)asyncMessage.contentType())) {
            messageBuilder.contentType(asyncMessage.contentType());
        }
    }

    public static List<String> getServers(AsyncOperation op, StringValueResolver stringValueResolver) {
        return Arrays.stream(op.servers()).map(arg_0 -> ((StringValueResolver)stringValueResolver).resolveStringValue(arg_0)).toList();
    }

    public static Map<String, ChannelBinding> processChannelBindingFromAnnotation(AnnotatedElement annotatedElement, List<ChannelBindingProcessor> channelBindingProcessors) {
        return channelBindingProcessors.stream().map(channelBindingProcessor -> channelBindingProcessor.process(annotatedElement)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ProcessedChannelBinding::getType, ProcessedChannelBinding::getBinding, (e1, e2) -> e1));
    }
}

