/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.message;

import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageHeaders;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessagePayload;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaReference;
import io.github.springwolf.core.asyncapi.annotations.AsyncOperation;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.scanners.bindings.messages.MessageBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AsyncAnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadAsyncOperationService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import io.github.springwolf.core.asyncapi.scanners.common.utils.TextUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringValueResolver;

public class AsyncAnnotationMessageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncAnnotationMessageService.class);
    private final PayloadAsyncOperationService payloadAsyncOperationService;
    private final ComponentsService componentsService;
    private final List<MessageBindingProcessor> messageBindingProcessors;
    private final StringValueResolver stringValueResolver;

    public MessageObject buildMessage(AsyncOperation operationData, Method method) {
        PayloadSchemaObject payloadSchema = this.payloadAsyncOperationService.extractSchema(operationData, method);
        SchemaObject headerSchema = AsyncAnnotationUtil.getAsyncHeaders(operationData, this.stringValueResolver);
        String headerSchemaName = this.componentsService.registerSchema(headerSchema);
        Map<String, MessageBinding> messageBinding = AsyncAnnotationUtil.processMessageBindingFromAnnotation(method, this.messageBindingProcessors);
        MessagePayload messagePayload = MessagePayload.of((MultiFormatSchema)MultiFormatSchema.builder().schema(payloadSchema.payload()).build());
        MessageObject.MessageObjectBuilder builder = MessageObject.builder().messageId(payloadSchema.name()).name(payloadSchema.name()).title(payloadSchema.title()).description(this.getDescription(operationData, payloadSchema)).payload(messagePayload).headers(MessageHeaders.of((SchemaReference)SchemaReference.toSchema((String)headerSchemaName))).bindings(messageBinding);
        AsyncAnnotationUtil.processAsyncMessageAnnotation(builder, operationData.message(), this.stringValueResolver);
        MessageObject message = builder.build();
        this.componentsService.registerMessage(message);
        return message;
    }

    private String getDescription(AsyncOperation operationData, PayloadSchemaObject payloadSchema) {
        String payloadDescription;
        String description = operationData.message().description();
        if (StringUtils.isBlank((CharSequence)description) && payloadSchema.payload() instanceof SchemaObject && StringUtils.isNotBlank((CharSequence)(payloadDescription = ((SchemaObject)payloadSchema.payload()).getDescription()))) {
            description = payloadDescription;
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            description = this.stringValueResolver.resolveStringValue(description);
            description = TextUtils.trimIndent(description);
        } else {
            description = null;
        }
        return description;
    }

    @Generated
    public AsyncAnnotationMessageService(PayloadAsyncOperationService payloadAsyncOperationService, ComponentsService componentsService, List<MessageBindingProcessor> messageBindingProcessors, StringValueResolver stringValueResolver) {
        this.payloadAsyncOperationService = payloadAsyncOperationService;
        this.componentsService = componentsService;
        this.messageBindingProcessors = messageBindingProcessors;
        this.stringValueResolver = stringValueResolver;
    }
}

