/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.payload.internal;

import io.github.springwolf.core.asyncapi.scanners.common.payload.internal.TypeExtractor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.Payload;

public class PayloadExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PayloadExtractor.class);
    private final TypeExtractor typeExtractor;

    public Optional<Type> extractFrom(Method method) {
        String methodName = String.format("%s::%s", method.getDeclaringClass().getSimpleName(), method.getName());
        log.debug("Finding payload type for {}", (Object)methodName);
        return this.getPayloadParameterIndex(method.getParameterTypes(), method.getParameterAnnotations(), methodName).map(parameterPayloadIndex -> method.getGenericParameterTypes()[parameterPayloadIndex]).map(this.typeExtractor::extractActualType);
    }

    private Optional<Integer> getPayloadParameterIndex(Class<?>[] parameterClasses, Annotation[][] parameterAnnotations, String methodName) {
        return switch (parameterClasses.length) {
            case 0 -> Optional.empty();
            case 1 -> Optional.of(0);
            default -> {
                int payloadAnnotatedParameterIndex = this.getPayloadAnnotatedParameterIndex(parameterAnnotations);
                if (payloadAnnotatedParameterIndex == -1) {
                    String msg = "Payload cannot be detected.  Multi-parameter method must have one parameter annotated with @Payload, but none was found: " + methodName;
                    throw new IllegalArgumentException(msg);
                }
                yield Optional.of(payloadAnnotatedParameterIndex);
            }
        };
    }

    private int getPayloadAnnotatedParameterIndex(Annotation[][] parameterAnnotations) {
        int length = parameterAnnotations.length;
        for (int i = 0; i < length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            boolean hasPayloadAnnotation = Arrays.stream(annotations).anyMatch(Payload.class::isInstance);
            if (!hasPayloadAnnotation) continue;
            return i;
        }
        return -1;
    }

    @Generated
    public PayloadExtractor(TypeExtractor typeExtractor) {
        this.typeExtractor = typeExtractor;
    }
}

