/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.operations.annotations;

import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationScannerUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.AnnotationUtil;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.operation.SpringAnnotationOperationsService;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationsInClassScanner;
import io.github.springwolf.core.asyncapi.scanners.operations.annotations.OperationCustomizer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationClassLevelOperationsScanner<ClassAnnotation extends Annotation, MethodAnnotation extends Annotation>
implements OperationsInClassScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationClassLevelOperationsScanner.class);
    private final Class<ClassAnnotation> classAnnotationClass;
    private final Class<MethodAnnotation> methodAnnotationClass;
    private final SpringAnnotationOperationsService<ClassAnnotation> springAnnotationOperationsService;
    private final List<OperationCustomizer> customizers;

    @Override
    public Stream<Operation> scan(Class<?> clazz) {
        return AnnotationScannerUtil.findAnnotatedMethods(clazz, this.classAnnotationClass, this.methodAnnotationClass, this::mapClassToOperation);
    }

    private Stream<Operation> mapClassToOperation(Class<?> component, Set<MethodAndAnnotation<MethodAnnotation>> annotatedMethods) {
        ClassAnnotation classAnnotation = AnnotationUtil.findFirstAnnotationOrThrow(this.classAnnotationClass, component);
        Set<Method> methods = annotatedMethods.stream().map(MethodAndAnnotation::method).collect(Collectors.toSet());
        Operation operation = this.springAnnotationOperationsService.buildOperation(classAnnotation, component, methods);
        annotatedMethods.forEach(method -> this.customizers.forEach(customizer -> customizer.customize(operation, method.method())));
        return Stream.of(operation);
    }

    @Generated
    public SpringAnnotationClassLevelOperationsScanner(Class<ClassAnnotation> classAnnotationClass, Class<MethodAnnotation> methodAnnotationClass, SpringAnnotationOperationsService<ClassAnnotation> springAnnotationOperationsService, List<OperationCustomizer> customizers) {
        this.classAnnotationClass = classAnnotationClass;
        this.methodAnnotationClass = methodAnnotationClass;
        this.springAnnotationOperationsService = springAnnotationOperationsService;
        this.customizers = customizers;
    }
}

