/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.schemas;

import io.github.springwolf.asyncapi.v3.model.ExternalDocumentation;
import io.github.springwolf.asyncapi.v3.model.components.ComponentSchema;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaReference;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.lang.Nullable;

public class SwaggerSchemaUtil {
    public Map<String, SchemaObject> mapSchemasMap(Map<String, Schema> schemaMap) {
        return schemaMap.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.mapSchema((Schema)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ComponentSchema mapSchemaOrRef(Schema schema) {
        if (schema.get$ref() != null) {
            return ComponentSchema.of((SchemaReference)new SchemaReference(schema.get$ref()));
        }
        return ComponentSchema.of((SchemaObject)this.mapSchema(schema));
    }

    public SchemaObject mapSchema(Schema value) {
        Schema items;
        List anyOf;
        List oneOf;
        List allOf;
        Object additionalProperties;
        List examples;
        Object example;
        SchemaObject.SchemaObjectBuilder builder = SchemaObject.builder();
        io.swagger.v3.oas.models.ExternalDocumentation externalDocs = value.getExternalDocs();
        if (externalDocs != null) {
            ExternalDocumentation externalDocumentation = ExternalDocumentation.builder().description(externalDocs.getDescription()).url(externalDocs.getUrl()).build();
            builder.externalDocs(externalDocumentation);
        }
        builder.deprecated(value.getDeprecated());
        builder.title(value.getTitle());
        builder.type(value.getType());
        Map properties = value.getProperties();
        if (properties != null) {
            Map<String, Object> propertiesMapped = properties.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.mapSchemaOrRef((Schema)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            builder.properties(propertiesMapped);
        }
        builder.description(value.getDescription());
        builder.format(value.getFormat());
        builder.pattern(value.getPattern());
        if (value.getExclusiveMinimum() != null && value.getExclusiveMinimum().booleanValue()) {
            builder.exclusiveMinimum(value.getMinimum());
        } else if (value.getExclusiveMinimumValue() != null) {
            builder.exclusiveMinimum(value.getExclusiveMinimumValue());
        } else {
            builder.minimum(value.getMinimum());
        }
        if (value.getExclusiveMaximum() != null && value.getExclusiveMaximum().booleanValue()) {
            builder.exclusiveMaximum(value.getMaximum());
        } else if (value.getExclusiveMaximumValue() != null) {
            builder.exclusiveMaximum(value.getExclusiveMaximumValue());
        } else {
            builder.maximum(value.getMaximum());
        }
        builder.multipleOf(value.getMultipleOf());
        builder.minLength(value.getMinLength());
        builder.maxLength(value.getMaxLength());
        List anEnum = value.getEnum();
        if (anEnum != null) {
            builder.enumValues(anEnum.stream().map(Object::toString).toList());
        }
        if ((example = value.getExample()) != null) {
            builder.examples(List.of(example));
        }
        if ((examples = value.getExamples()) != null && !examples.isEmpty()) {
            builder.examples(examples);
        }
        if ((additionalProperties = value.getAdditionalProperties()) instanceof Schema) {
            builder.additionalProperties(this.mapSchemaOrRef((Schema)additionalProperties));
        }
        builder.required(value.getRequired());
        if (value.getDiscriminator() != null) {
            builder.discriminator(value.getDiscriminator().getPropertyName());
        }
        if ((allOf = value.getAllOf()) != null) {
            builder.allOf(allOf.stream().filter(el -> el instanceof Schema).map(schema -> this.mapSchemaOrRef((Schema)schema)).collect(Collectors.toList()));
        }
        if ((oneOf = value.getOneOf()) != null) {
            builder.oneOf(oneOf.stream().filter(el -> el instanceof Schema).map(schema -> this.mapSchemaOrRef((Schema)schema)).collect(Collectors.toList()));
        }
        if ((anyOf = value.getAnyOf()) != null) {
            builder.anyOf(anyOf.stream().filter(el -> el instanceof Schema).map(schema -> this.mapSchemaOrRef((Schema)schema)).collect(Collectors.toList()));
        }
        builder.constValue(value.getConst());
        Schema not = value.getNot();
        if (not != null) {
            builder.not(this.mapSchemaOrRef(not));
        }
        if ((items = value.getItems()) != null && "array".equals(value.getType())) {
            builder.items(this.mapSchemaOrRef(items));
        }
        builder.uniqueItems(value.getUniqueItems());
        builder.minItems(value.getMinItems());
        builder.maxItems(value.getMaxItems());
        return builder.build();
    }

    public Object unwrapSchema(Object schema) {
        if (schema instanceof ComponentSchema) {
            ComponentSchema componentSchema = (ComponentSchema)schema;
            SchemaObject unwrappedSchema = componentSchema.getSchema();
            if (unwrappedSchema == null) {
                unwrappedSchema = componentSchema.getReference();
            }
            if (unwrappedSchema == null) {
                unwrappedSchema = componentSchema.getMultiFormatSchema();
            }
            return this.unwrapSchema(unwrappedSchema);
        }
        if (schema instanceof MultiFormatSchema) {
            MultiFormatSchema multiFormatSchema = (MultiFormatSchema)schema;
            return this.unwrapSchema(multiFormatSchema.getSchema());
        }
        return schema;
    }

    @Nullable
    public Schema<?> mapToSwagger(Object schema) {
        Object unwrappedSchema = this.unwrapSchema(schema);
        if (unwrappedSchema instanceof Schema) {
            Schema swaggerSchema = (Schema)unwrappedSchema;
            return swaggerSchema;
        }
        if (unwrappedSchema instanceof SchemaObject) {
            SchemaObject schemaObject = (SchemaObject)unwrappedSchema;
            return this.mapSchemaObjectToSwagger(schemaObject);
        }
        if (unwrappedSchema instanceof SchemaReference) {
            SchemaReference schemaReference = (SchemaReference)unwrappedSchema;
            return this.mapSchemaReferenceToSwagger(schemaReference);
        }
        throw new RuntimeException("Could not convert '" + String.valueOf(schema) + "' to a Swagger Schema");
    }

    private Schema mapSchemaObjectToSwagger(SchemaObject asyncApiSchema) {
        Schema swaggerSchema = new Schema();
        swaggerSchema.setType(asyncApiSchema.getType());
        swaggerSchema.setDescription(asyncApiSchema.getDescription());
        swaggerSchema.setExamples(asyncApiSchema.getExamples());
        swaggerSchema.setEnum(asyncApiSchema.getEnumValues());
        return swaggerSchema;
    }

    private Schema mapSchemaReferenceToSwagger(SchemaReference asyncApiSchemaReference) {
        Schema swaggerSchema = new Schema();
        swaggerSchema.set$ref(asyncApiSchemaReference.getRef());
        return swaggerSchema;
    }

    @Generated
    public SwaggerSchemaUtil() {
    }
}

