/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.configuration;

import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Order(value=-2147483648)
public class SpringwolfUiResourceConfigurer
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringwolfUiResourceConfigurer.class);
    private final SpringwolfConfigProperties springwolfConfigProperties;
    private final WebProperties webProperties;
    private final WebMvcProperties webMvcProperties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String springwolfBasePath = this.springwolfConfigProperties.getPath().getBase();
        log.debug("Serving Springwolf with base-path: {}", (Object)springwolfBasePath);
        registry.addResourceHandler(new String[]{springwolfBasePath + "/**", this.webMvcProperties.getStaticPathPattern()}).addResourceLocations(this.buildStaticLocation());
    }

    private String[] buildStaticLocation() {
        ArrayList<String> staticLocations = new ArrayList<String>(Arrays.asList(this.webProperties.getResources().getStaticLocations()));
        staticLocations.add("classpath:/META-INF/resources/springwolf/");
        return staticLocations.toArray(new String[0]);
    }

    @Generated
    public SpringwolfUiResourceConfigurer(SpringwolfConfigProperties springwolfConfigProperties, WebProperties webProperties, WebMvcProperties webMvcProperties) {
        this.springwolfConfigProperties = springwolfConfigProperties;
        this.webProperties = webProperties;
        this.webMvcProperties = webMvcProperties;
    }
}

