/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.standalone;

import io.github.springwolf.core.asyncapi.AsyncApiService;
import io.github.springwolf.core.standalone.StandaloneApplication;
import io.github.springwolf.core.standalone.StandaloneConfigurationDiscoverer;
import io.github.springwolf.core.standalone.StandaloneEnvironmentLoader;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class DefaultStandaloneApplication
implements StandaloneApplication {
    private final AnnotationConfigApplicationContext diContext = new AnnotationConfigApplicationContext();

    private DefaultStandaloneApplication(ConfigurableEnvironment environment, List<Class<?>> standaloneConfigurations) {
        this.diContext.setEnvironment(environment);
        standaloneConfigurations.forEach(xva$0 -> this.diContext.register(new Class[]{xva$0}));
        ConfigurationPropertiesBindingPostProcessor.register((BeanDefinitionRegistry)this.diContext);
        this.diContext.refresh();
        this.verifyContextHasAllRequiredBeans();
    }

    private void verifyContextHasAllRequiredBeans() {
        try {
            this.getAsyncApiService();
        }
        catch (Exception e) {
            throw new IllegalStateException("Missing required beans in Springwolf standalone context", e);
        }
    }

    @Override
    public AsyncApiService getAsyncApiService() {
        return (AsyncApiService)this.diContext.getBean(AsyncApiService.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private DefaultStandaloneApplication() {
    }

    public static class Builder {
        @Nullable
        private ConfigurableEnvironment environment;
        private final List<String> scanPackages = new ArrayList<String>(List.of("io.github.springwolf"));

        public Builder setEnvironment(ConfigurableEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public Builder addScanPackage(String scanPackage) {
            return this.addScanPackages(List.of(scanPackage));
        }

        public Builder addScanPackages(List<String> scanPackages) {
            this.scanPackages.addAll(scanPackages);
            return this;
        }

        public Builder setScanPackages(List<String> scanPackages) {
            this.scanPackages.clear();
            this.scanPackages.addAll(scanPackages);
            return this;
        }

        public DefaultStandaloneApplication buildAndStart() {
            ConfigurableEnvironment actualEnvironment = this.environment != null ? this.environment : StandaloneEnvironmentLoader.load();
            List<Class<?>> actualStandaloneConfigurations = StandaloneConfigurationDiscoverer.scan(String.join((CharSequence)",", this.scanPackages), actualEnvironment);
            return new DefaultStandaloneApplication(actualEnvironment, actualStandaloneConfigurations);
        }

        @Generated
        private Builder() {
        }
    }
}

