/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.bindings.kafka.configuration;

import io.github.springwolf.bindings.kafka.scanners.channels.KafkaChannelBindingProcessor;
import io.github.springwolf.bindings.kafka.scanners.messages.KafkaMessageBindingProcessor;
import io.github.springwolf.bindings.kafka.scanners.operations.KafkaOperationBindingProcessor;
import io.github.springwolf.core.standalone.StandaloneConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringValueResolver;

@AutoConfiguration
@ConditionalOnProperty(name={"springwolf.enabled"}, havingValue="true", matchIfMissing=true)
@StandaloneConfiguration
public class SpringwolfKafkaBindingAutoConfiguration {
    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean
    public KafkaChannelBindingProcessor kafkaChannelBindingProcessor(StringValueResolver stringValueResolver) {
        return new KafkaChannelBindingProcessor(stringValueResolver);
    }

    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean
    public KafkaOperationBindingProcessor kafkaOperationBindingProcessor(StringValueResolver stringValueResolver) {
        return new KafkaOperationBindingProcessor(stringValueResolver);
    }

    @Bean
    @Order(value=3)
    @ConditionalOnMissingBean
    public KafkaMessageBindingProcessor kafkaMessageBindingProcessor(StringValueResolver stringValueResolver) {
        return new KafkaMessageBindingProcessor(stringValueResolver);
    }
}

