/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.bindings.kafka.scanners.channels;

import io.github.springwolf.asyncapi.v3.bindings.ChannelBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaChannelBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaChannelTopicCleanupPolicy;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaChannelTopicConfiguration;
import io.github.springwolf.bindings.kafka.annotations.KafkaAsyncChannelBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.AbstractChannelBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.channels.ProcessedChannelBinding;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.StringValueResolver;

public class KafkaChannelBindingProcessor
extends AbstractChannelBindingProcessor<KafkaAsyncChannelBinding> {
    private static final KafkaChannelTopicConfiguration EMPTY_TOPIC_CONFIGURATION = KafkaChannelTopicConfiguration.builder().build();

    public KafkaChannelBindingProcessor(StringValueResolver stringValueResolver) {
        super(stringValueResolver);
    }

    protected ProcessedChannelBinding mapToChannelBinding(KafkaAsyncChannelBinding bindingAnnotation) {
        KafkaChannelBinding.KafkaChannelBindingBuilder bindingBuilder = KafkaChannelBinding.builder();
        if (StringUtils.isNotBlank((CharSequence)bindingAnnotation.topic())) {
            bindingBuilder.topic(this.resolveOrNull(bindingAnnotation.topic()));
        }
        if (bindingAnnotation.partitions() != Integer.MIN_VALUE) {
            bindingBuilder.partitions(Integer.valueOf(bindingAnnotation.partitions()));
        }
        if (bindingAnnotation.replicas() != Integer.MIN_VALUE) {
            bindingBuilder.replicas(Integer.valueOf(bindingAnnotation.replicas()));
        }
        bindingBuilder.topicConfiguration(this.mapToTopicConfiguration(bindingAnnotation));
        return new ProcessedChannelBinding("kafka", (ChannelBinding)bindingBuilder.build());
    }

    private KafkaChannelTopicConfiguration mapToTopicConfiguration(KafkaAsyncChannelBinding bindingAnnotation) {
        KafkaChannelTopicConfiguration buildTopicConfiguration;
        KafkaChannelTopicConfiguration.KafkaChannelTopicConfigurationBuilder topicConfiguration = KafkaChannelTopicConfiguration.builder();
        if (bindingAnnotation.topicConfiguration().cleanup().length > 0) {
            topicConfiguration.cleanupPolicy(Arrays.stream(bindingAnnotation.topicConfiguration().cleanup()).map(this::toKafkaChannelTopicCleanupPolicy).toList());
        }
        if (bindingAnnotation.topicConfiguration().retentionMs() != Integer.MIN_VALUE) {
            topicConfiguration.retentionMs(Long.valueOf(bindingAnnotation.topicConfiguration().retentionMs()));
        }
        if (bindingAnnotation.topicConfiguration().retentionBytes() != Integer.MIN_VALUE) {
            topicConfiguration.retentionBytes(Long.valueOf(bindingAnnotation.topicConfiguration().retentionBytes()));
        }
        if (bindingAnnotation.topicConfiguration().deleteRetentionMs() != Integer.MIN_VALUE) {
            topicConfiguration.deleteRetentionMs(Long.valueOf(bindingAnnotation.topicConfiguration().deleteRetentionMs()));
        }
        if (bindingAnnotation.topicConfiguration().maxMessageBytes() != Integer.MIN_VALUE) {
            topicConfiguration.maxMessageBytes(Integer.valueOf(bindingAnnotation.topicConfiguration().maxMessageBytes()));
        }
        if (EMPTY_TOPIC_CONFIGURATION.equals((Object)(buildTopicConfiguration = topicConfiguration.build()))) {
            return null;
        }
        return buildTopicConfiguration;
    }

    private KafkaChannelTopicCleanupPolicy toKafkaChannelTopicCleanupPolicy(KafkaAsyncChannelBinding.KafkaChannelTopicConfiguration.CleanupPolicy cleanupType) {
        return switch (cleanupType) {
            default -> throw new IncompatibleClassChangeError();
            case KafkaAsyncChannelBinding.KafkaChannelTopicConfiguration.CleanupPolicy.COMPACT -> KafkaChannelTopicCleanupPolicy.COMPACT;
            case KafkaAsyncChannelBinding.KafkaChannelTopicConfiguration.CleanupPolicy.DELETE -> KafkaChannelTopicCleanupPolicy.DELETE;
        };
    }
}

