/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.plugins.kafka.producer;

import io.github.springwolf.plugins.kafka.configuration.SpringwolfKafkaProducerConfiguration;
import io.github.springwolf.plugins.kafka.configuration.properties.SpringwolfKafkaConfigProperties;
import io.github.springwolf.plugins.kafka.producer.SpringwolfKafkaTemplateProvider;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.ssl.DefaultSslBundleRegistry;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@ConditionalOnBean(value={SpringwolfKafkaProducerConfiguration.class})
public class SpringwolfKafkaTemplateFromProperties
implements SpringwolfKafkaTemplateProvider {
    private final Optional<KafkaTemplate<Object, Object>> kafkaTemplate;

    public SpringwolfKafkaTemplateFromProperties(SpringwolfKafkaConfigProperties springWolfKafkaConfigProperties) {
        if (springWolfKafkaConfigProperties.getPublishing() != null && springWolfKafkaConfigProperties.getPublishing().getProducer() != null) {
            Map producerProperties = springWolfKafkaConfigProperties.getPublishing().getProducer().buildProperties((SslBundles)new DefaultSslBundleRegistry());
            DefaultKafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory(producerProperties);
            this.kafkaTemplate = Optional.of(new KafkaTemplate((ProducerFactory)producerFactory));
        } else {
            this.kafkaTemplate = Optional.empty();
        }
    }

    @Override
    public boolean isPresent() {
        return this.kafkaTemplate.isPresent();
    }

    @Override
    public Optional<KafkaTemplate<Object, Object>> get(String topic) {
        return this.kafkaTemplate;
    }

    @Generated
    public SpringwolfKafkaTemplateFromProperties(Optional<KafkaTemplate<Object, Object>> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

