/*
 * Decompiled with CFR 0.152.
 */
package io.github.t12y.resemble;

import io.github.t12y.resemble.Options;

public class Resemble {
    private static final int ANTIALIASING_DISTANCE = 1;
    private final double[] baselinePixels;
    private final double[] latestPixels;
    private final Options options;

    private Resemble(double[] baselinePixels, double[] latestPixels, Options options) {
        this.baselinePixels = baselinePixels;
        this.latestPixels = latestPixels;
        this.options = options;
    }

    public static double analyzeImages(double[] baselinePixels, double[] latestPixels, Options options) {
        return new Resemble(baselinePixels, latestPixels, options).analyzeImages();
    }

    private double analyzeImages() {
        int mismatchCount = 0;
        for (int x = 0; x < this.options.width; ++x) {
            for (int y = 0; y < this.options.height; ++y) {
                int offset = (y * this.options.width + x) * 4;
                if (offset > this.baselinePixels.length || !this.withinComparedArea(x, y) || this.isIgnoredColor(offset)) continue;
                if (this.options.ignoreColors) {
                    if (this.isPixelBrightnessSimilar(offset)) continue;
                    ++mismatchCount;
                    continue;
                }
                if (this.isRGBSimilar(offset) || this.options.ignoreAntialiasing && (this.isAntialiased(offset, this.baselinePixels, x, y) || this.isAntialiased(offset, this.latestPixels, x, y)) && this.isPixelBrightnessSimilar(offset)) continue;
                ++mismatchCount;
            }
        }
        return (double)mismatchCount / (double)(this.options.height * this.options.width) * 100.0;
    }

    private boolean withinComparedArea(int x, int y) {
        if (this.options.ignoredBoxes == null) {
            return true;
        }
        for (int[] box : this.options.ignoredBoxes) {
            if (x < box[0] || x > box[1] || y < box[2] || y > box[3]) continue;
            return false;
        }
        return true;
    }

    private boolean isIgnoredColor(int offset) {
        double bDifference;
        double gDifference;
        if (this.options.ignoreAreasColoredWith == null) {
            return false;
        }
        double rDifference = Math.abs(this.latestPixels[offset] - (double)this.options.ignoreAreasColoredWith[0]);
        double avgDifference = (rDifference + (gDifference = Math.abs(this.latestPixels[offset + 1] - (double)this.options.ignoreAreasColoredWith[1])) + (bDifference = Math.abs(this.latestPixels[offset + 2] - (double)this.options.ignoreAreasColoredWith[2]))) / 3.0;
        return avgDifference == 0.0;
    }

    private boolean isRGBSimilar(int offset) {
        boolean isSimilar = Resemble.isColorSimilar(this.baselinePixels[offset], this.latestPixels[offset], this.options.redTolerance);
        isSimilar = isSimilar && Resemble.isColorSimilar(this.baselinePixels[offset + 1], this.latestPixels[offset + 1], this.options.greenTolerance);
        isSimilar = isSimilar && Resemble.isColorSimilar(this.baselinePixels[offset + 2], this.latestPixels[offset + 2], this.options.blueTolerance);
        isSimilar = isSimilar && Resemble.isColorSimilar(this.baselinePixels[offset + 3], this.latestPixels[offset + 3], this.options.alphaTolerance);
        return isSimilar;
    }

    private boolean isRGBSame(int baselineOffset, int latestOffset, double[] pixels) {
        boolean isSame = pixels[baselineOffset] == pixels[latestOffset];
        isSame = isSame && pixels[baselineOffset + 1] == pixels[latestOffset + 1];
        isSame = isSame && pixels[baselineOffset + 2] == pixels[latestOffset + 2];
        return isSame;
    }

    private static boolean isColorSimilar(double baselineColor, double latestColor, double tolerance) {
        if (baselineColor == latestColor) {
            return true;
        }
        return Math.abs(baselineColor - latestColor) < tolerance;
    }

    private static double getBrightness(int offset, double[] pixels) {
        return 0.3 * pixels[offset] + 0.59 * pixels[offset + 1] + 0.11 * pixels[offset + 2];
    }

    private boolean isPixelBrightnessSimilar(int offset) {
        double baselineBrightness = Resemble.getBrightness(offset, this.baselinePixels);
        double latestBrightness = Resemble.getBrightness(offset, this.latestPixels);
        boolean isSimilar = Resemble.isColorSimilar(this.baselinePixels[offset + 3], this.latestPixels[offset + 3], this.options.alphaTolerance);
        isSimilar = isSimilar && Resemble.isColorSimilar(baselineBrightness, latestBrightness, this.options.minBrightness);
        return isSimilar;
    }

    private static double getHue(int offset, double[] pixels) {
        double r = pixels[offset] / 255.0;
        double g = pixels[offset + 1] / 255.0;
        double b = pixels[offset + 2] / 255.0;
        double max = Math.max(Math.max(r, g), b);
        double min = Math.min(Math.min(r, g), b);
        double h = 0.0;
        if (max == min) {
            h = 0.0;
        } else {
            double d = max - min;
            h = max == r ? (g - b) / d + (g < b ? 6.0 : 0.0) : (max == g ? (b - r) / d + 2.0 : (max == b ? (r - g) / d + 4.0 : (h /= 6.0)));
        }
        return h;
    }

    private boolean isAntialiased(int sourceOffset, double[] pixels, int x, int y) {
        int hasSiblingWithDifferentHue = 0;
        int hasHighContrastSibling = 0;
        int hasEquivalentSibling = 0;
        double sourceBrightness = Resemble.getBrightness(sourceOffset, pixels);
        double sourceHue = Resemble.getHue(sourceOffset, pixels);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                int targetOffset;
                if (i == 0 && j == 0 || (targetOffset = ((x + j) * this.options.width + (y + i)) * 4) > pixels.length || targetOffset < 0) continue;
                double targetBrightness = Resemble.getBrightness(targetOffset, pixels);
                double targetHue = Resemble.getHue(targetOffset, pixels);
                if (Math.abs(sourceBrightness - targetBrightness) > this.options.maxBrightness) {
                    ++hasHighContrastSibling;
                }
                if (this.isRGBSame(sourceOffset, targetOffset, pixels)) {
                    ++hasEquivalentSibling;
                }
                if (Math.abs(targetHue - sourceHue) > 0.3) {
                    ++hasSiblingWithDifferentHue;
                }
                if (hasSiblingWithDifferentHue <= 1 && hasHighContrastSibling <= 1) continue;
                return true;
            }
        }
        return hasEquivalentSibling < 2;
    }
}

