/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.internal.McCabeVisitor;
import io.gitlab.arturbosch.detekt.api.internal.McCabeVisitorKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e*\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/api/internal/McCabeVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "ignoreSimpleWhenEntries", "", "(Z)V", "value", "", "mcc", "getMcc", "()I", "setMcc", "(I)V", "isInsideObjectLiteral", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitNamedFunction", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "extractEntries", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "detekt-api"})
public final class McCabeVisitor
extends DetektVisitor {
    private int mcc;
    private final boolean ignoreSimpleWhenEntries;

    public final int getMcc() {
        return this.mcc;
    }

    private final void setMcc(int value) {
        this.mcc = value;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (!this.isInsideObjectLiteral(function)) {
            McCabeVisitor mcCabeVisitor = this;
            int n = mcCabeVisitor.mcc;
            mcCabeVisitor.setMcc(n + 1);
            super.visitNamedFunction(function);
        }
    }

    private final boolean isInsideObjectLiteral(KtNamedFunction function) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)function;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtObjectLiteralExpression.class, (boolean)true) != null;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        McCabeVisitor mcCabeVisitor = this;
        int n = mcCabeVisitor.mcc;
        mcCabeVisitor.setMcc(n + 1);
        if (expression.getElse() != null) {
            McCabeVisitor mcCabeVisitor2 = this;
            n = mcCabeVisitor2.mcc;
            mcCabeVisitor2.setMcc(n + 1);
        }
        super.visitIfExpression(expression);
    }

    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkParameterIsNotNull((Object)loopExpression, (String)"loopExpression");
        McCabeVisitor mcCabeVisitor = this;
        int n = mcCabeVisitor.mcc;
        mcCabeVisitor.setMcc(n + 1);
        super.visitLoopExpression(loopExpression);
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Sequence<KtWhenEntry> entries = this.extractEntries(expression, this.ignoreSimpleWhenEntries);
        McCabeVisitor mcCabeVisitor = this;
        mcCabeVisitor.setMcc(mcCabeVisitor.mcc + (this.ignoreSimpleWhenEntries && SequencesKt.count(entries) == 0 ? 1 : SequencesKt.count(entries)));
        super.visitWhenExpression(expression);
    }

    private final Sequence<KtWhenEntry> extractEntries(@NotNull KtWhenExpression $this$extractEntries, boolean ignoreSimpleWhenEntries) {
        List list = $this$extractEntries.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"entries");
        Sequence entries = CollectionsKt.asSequence((Iterable)list);
        return ignoreSimpleWhenEntries ? SequencesKt.filter((Sequence)entries, (Function1)extractEntries.1.INSTANCE) : entries;
    }

    public void visitTryExpression(@NotNull KtTryExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        McCabeVisitor mcCabeVisitor = this;
        int n = mcCabeVisitor.mcc;
        mcCabeVisitor.setMcc(n + 1);
        McCabeVisitor mcCabeVisitor2 = this;
        mcCabeVisitor2.setMcc(mcCabeVisitor2.mcc + expression.getCatchClauses().size());
        KtFinallySection ktFinallySection = expression.getFinallyBlock();
        if (ktFinallySection != null) {
            KtFinallySection ktFinallySection2 = ktFinallySection;
            boolean bl = false;
            boolean bl2 = false;
            KtFinallySection it = ktFinallySection2;
            boolean bl3 = false;
            McCabeVisitor mcCabeVisitor3 = this;
            int n2 = mcCabeVisitor3.mcc;
            mcCabeVisitor3.setMcc(n2 + 1);
        }
        super.visitTryExpression(expression);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (McCabeVisitorKt.isUsedForNesting(expression)) {
            KtLambdaArgument lambdaArgument;
            KtLambdaExpression ktLambdaExpression;
            List list = expression.getLambdaArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"expression.lambdaArguments");
            List lambdaArguments = list;
            if (lambdaArguments.size() > 0 && (ktLambdaExpression = (lambdaArgument = (KtLambdaArgument)lambdaArguments.get(0)).getLambdaExpression()) != null && (ktLambdaExpression = ktLambdaExpression.getBodyExpression()) != null) {
                KtLambdaExpression ktLambdaExpression2 = ktLambdaExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtLambdaExpression it = ktLambdaExpression2;
                boolean bl3 = false;
                McCabeVisitor mcCabeVisitor = this;
                int n = mcCabeVisitor.mcc;
                mcCabeVisitor.setMcc(n + 1);
            }
        }
        super.visitCallExpression(expression);
    }

    public McCabeVisitor(boolean ignoreSimpleWhenEntries) {
        this.ignoreSimpleWhenEntries = ignoreSimpleWhenEntries;
    }
}

