/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api.internal;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.CommaSeparatedPattern;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.api.internal.ValidatableConfiguration;
import io.gitlab.arturbosch.detekt.api.internal.YamlConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\" \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"DEFAULT_PROPERTY_EXCLUDES", "", "getDEFAULT_PROPERTY_EXCLUDES", "()Ljava/lang/String;", "DEPRECATED_PROPERTIES", "", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "nestedConfigurationExpected", "Lio/gitlab/arturbosch/detekt/api/Notification;", "prop", "propertyDoesNotExists", "propertyIsDeprecated", "deprecationDescription", "unexpectedNestedConfiguration", "validateConfig", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "baseline", "excludePatterns", "", "detekt-api"})
public final class ValidatableConfigurationKt {
    @NotNull
    private static final String DEFAULT_PROPERTY_EXCLUDES;
    private static final List<Pair<Regex, String>> DEPRECATED_PROPERTIES;

    @NotNull
    public static final String getDEFAULT_PROPERTY_EXCLUDES() {
        return DEFAULT_PROPERTY_EXCLUDES;
    }

    @NotNull
    public static final List<Notification> validateConfig(@NotNull Config config, @NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)baseline, (String)"baseline");
        Intrinsics.checkParameterIsNotNull(excludePatterns, (String)"excludePatterns");
        boolean bl = Intrinsics.areEqual((Object)baseline, (Object)Config.Companion.getEmpty()) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot validate configuration based on an empty baseline config.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = baseline instanceof YamlConfig;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String yamlConfigClass = Reflection.getOrCreateKotlinClass(YamlConfig.class).getSimpleName();
            String actualClass = baseline.getClass().getSimpleName();
            String string = "Only supported baseline config is the " + yamlConfigClass + ". Actual type is " + actualClass;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)config, (Object)Config.Companion.getEmpty())) {
            return CollectionsKt.emptyList();
        }
        bl2 = false;
        List notifications = new ArrayList();
        Function3<Map<String, ? extends Object>, Map<String, ? extends Object>, String, Unit> $fun$testKeys$3 = new Function3<Map<String, ? extends Object>, Map<String, ? extends Object>, String, Unit>(excludePatterns, notifications){
            final /* synthetic */ Set $excludePatterns;
            final /* synthetic */ List $notifications;

            public final void invoke(@NotNull Map<String, ? extends Object> current, @NotNull Map<String, ? extends Object> base, @Nullable String parentPath) {
                Intrinsics.checkParameterIsNotNull(current, (String)"current");
                Intrinsics.checkParameterIsNotNull(base, (String)"base");
                for (String prop : current.keySet()) {
                    Object object;
                    boolean isExcluded;
                    Map<String, ? extends Object> map;
                    boolean $i$f$any;
                    Object $this$any$iv;
                    boolean isDeprecated;
                    Pair matchedDeprecation;
                    String propertyPath;
                    block13: {
                        boolean bl;
                        Object v0;
                        block12: {
                            propertyPath = (parentPath == null ? "" : parentPath + '>') + prop;
                            Iterable iterable = ValidatableConfigurationKt.access$getDEPRECATED_PROPERTIES$p();
                            boolean bl2 = false;
                            Iterable iterable2 = iterable;
                            boolean bl3 = false;
                            for (T t : iterable2) {
                                Pair $dstr$regex$_u24__u24 = (Pair)t;
                                boolean bl4 = false;
                                Regex regex = (Regex)$dstr$regex$_u24__u24.component1();
                                if (!regex.matches((CharSequence)propertyPath)) continue;
                                v0 = t;
                                break block12;
                            }
                            v0 = null;
                        }
                        matchedDeprecation = v0;
                        isDeprecated = matchedDeprecation != null;
                        $this$any$iv = this.$excludePatterns;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            map = $this$any$iv.iterator();
                            while (map.hasNext()) {
                                T element$iv = map.next();
                                Regex it = (Regex)element$iv;
                                boolean bl5 = false;
                                if (!it.matches((CharSequence)propertyPath)) continue;
                                bl = true;
                                break block13;
                            }
                            bl = isExcluded = false;
                        }
                    }
                    if (isDeprecated) {
                        Pair pair = matchedDeprecation;
                        if (pair == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$notifications.add(ValidatableConfigurationKt.propertyIsDeprecated(propertyPath, (String)pair.getSecond()));
                    }
                    if (isDeprecated || isExcluded) continue;
                    $this$any$iv = base;
                    $i$f$any = false;
                    map = $this$any$iv;
                    boolean bl = false;
                    if (!map.containsKey(prop)) {
                        this.$notifications.add(ValidatableConfigurationKt.propertyDoesNotExists(propertyPath));
                    }
                    if (!((object = current.get(prop)) instanceof Map)) {
                        object = null;
                    }
                    Map next = (Map)object;
                    Object object2 = base.get(prop);
                    if (!(object2 instanceof Map)) {
                        object2 = null;
                    }
                    Map nextBase = (Map)object2;
                    if (next == null && nextBase != null) {
                        this.$notifications.add(ValidatableConfigurationKt.nestedConfigurationExpected(propertyPath));
                        continue;
                    }
                    map = base;
                    bl = false;
                    Map<String, ? extends Object> map2 = map;
                    boolean bl6 = false;
                    if (map2.containsKey(prop) && next != null && nextBase == null) {
                        this.$notifications.add(ValidatableConfigurationKt.unexpectedNestedConfiguration(propertyPath));
                        continue;
                    }
                    if (next == null || nextBase == null) continue;
                    this.invoke(next, nextBase, propertyPath);
                }
            }
            {
                this.$excludePatterns = set;
                this.$notifications = list;
                super(3);
            }
        };
        Config config2 = config;
        if (config2 instanceof YamlConfig) {
            $fun$testKeys$3.invoke(((YamlConfig)config).getProperties(), ((YamlConfig)baseline).getProperties(), null);
        } else if (config2 instanceof ValidatableConfiguration) {
            notifications.addAll((Collection)((ValidatableConfiguration)((Object)config)).validate(baseline, excludePatterns));
        } else {
            String string = "Unsupported config type for validation: '" + Reflection.getOrCreateKotlinClass(config.getClass()) + "'.";
            boolean bl6 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return notifications;
    }

    public static /* synthetic */ List validateConfig$default(Config config, Config config2, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = new CommaSeparatedPattern(DEFAULT_PROPERTY_EXCLUDES, null, 2, null).mapToRegex();
        }
        return ValidatableConfigurationKt.validateConfig(config, config2, set);
    }

    @NotNull
    public static final Notification propertyDoesNotExists(@NotNull String prop) {
        Intrinsics.checkParameterIsNotNull((Object)prop, (String)"prop");
        return new SimpleNotification("Property '" + prop + "' is misspelled or does not exist.", null, 2, null);
    }

    @NotNull
    public static final Notification nestedConfigurationExpected(@NotNull String prop) {
        Intrinsics.checkParameterIsNotNull((Object)prop, (String)"prop");
        return new SimpleNotification("Nested config expected for '" + prop + "'.", null, 2, null);
    }

    @NotNull
    public static final Notification unexpectedNestedConfiguration(@NotNull String prop) {
        Intrinsics.checkParameterIsNotNull((Object)prop, (String)"prop");
        return new SimpleNotification("Unexpected nested config for '" + prop + "'.", null, 2, null);
    }

    @NotNull
    public static final Notification propertyIsDeprecated(@NotNull String prop, @NotNull String deprecationDescription) {
        Intrinsics.checkParameterIsNotNull((Object)prop, (String)"prop");
        Intrinsics.checkParameterIsNotNull((Object)deprecationDescription, (String)"deprecationDescription");
        return new SimpleNotification("Property '" + prop + "' is deprecated. " + deprecationDescription + '.', Notification.Level.Warning);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        DEFAULT_PROPERTY_EXCLUDES = CollectionsKt.joinToString$default((Iterable)SetsKt.setOf((Object[])new String[]{".*>.*>excludes", ".*>.*>includes", ".*>.*>active", ".*>.*>autoCorrect", "build>weights.*"}), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Iterable $this$map$iv = SetsKt.setOf((Object[])new Pair[]{TuplesKt.to((Object)"complexity>LongParameterList>threshold", (Object)"Use 'functionThreshold' and 'constructorThreshold' instead"), TuplesKt.to((Object)"empty-blocks>EmptyFunctionBlock>ignoreOverriddenFunctions", (Object)"Use 'ignoreOverridden' instead"), TuplesKt.to((Object)"naming>FunctionParameterNaming>ignoreOverriddenFunctions", (Object)"Use 'ignoreOverridden' instead"), TuplesKt.to((Object)"naming>MemberNameEqualsClassName>ignoreOverriddenFunction", (Object)"Use 'ignoreOverridden' instead")});
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void first;
            void $dstr$first$second;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)$dstr$first$second.component1();
            String second = (String)$dstr$first$second.component2();
            void var11_11 = first;
            boolean bl2 = false;
            Pair pair2 = TuplesKt.to((Object)new Regex((String)var11_11), (Object)second);
            collection.add(pair2);
        }
        DEPRECATED_PROPERTIES = (List)var3_3;
    }

    public static final /* synthetic */ List access$getDEPRECATED_PROPERTIES$p() {
        return DEPRECATED_PROPERTIES;
    }
}

