/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.utils;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import java.util.Arrays;

public final class UUID {
    private static final RandomBasedGenerator uuidGenerator = Generators.randomBasedGenerator();
    private static final long[] lookup = UUID.buildLookup();
    private static final int DASH = -1;
    private static final int ERROR = -2;
    private static final char[][] recode = UUID.buildByteBlocks();

    private UUID() {
    }

    private static long[] buildLookup() {
        long[] lu = new long[128];
        Arrays.fill(lu, -2L);
        lu[48] = 0L;
        lu[49] = 1L;
        lu[50] = 2L;
        lu[51] = 3L;
        lu[52] = 4L;
        lu[53] = 5L;
        lu[54] = 6L;
        lu[55] = 7L;
        lu[56] = 8L;
        lu[57] = 9L;
        lu[97] = 10L;
        lu[98] = 11L;
        lu[99] = 12L;
        lu[100] = 13L;
        lu[101] = 14L;
        lu[102] = 15L;
        lu[65] = 10L;
        lu[66] = 11L;
        lu[67] = 12L;
        lu[68] = 13L;
        lu[69] = 14L;
        lu[70] = 15L;
        lu[45] = -1L;
        return lu;
    }

    public static java.util.UUID fromString(String str) {
        int len = str.length();
        if (len != 36) {
            throw new IllegalArgumentException("Invalid UUID string (expected to be 36 characters long)");
        }
        long[] vals = new long[2];
        int shift = 60;
        int index = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= lookup.length || lookup[c] == -2L) {
                throw new IllegalArgumentException("Invalid UUID string (unexpected '" + str.charAt(i) + "' at position " + i + " -> " + str + " )");
            }
            if (lookup[c] == -1L) {
                if ((i - 8) % 5 == 0) continue;
                throw new IllegalArgumentException("Invalid UUID string (unexpected '-' at position " + i + " -> " + str + " )");
            }
            int n = index++;
            vals[n] = vals[n] | lookup[c] << shift;
            if ((shift -= 4) >= 0) continue;
            shift = 60;
        }
        return new java.util.UUID(vals[0], vals[1]);
    }

    private static char[][] buildByteBlocks() {
        char[][] ret = new char[256][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = String.format("%02x", i).toCharArray();
        }
        return ret;
    }

    public static String toString(java.util.UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        char[] uuidChars = new char[36];
        int cursor = uuidChars.length;
        while (cursor > 24) {
            System.arraycopy(recode[(int)(lsb & 0xFFL)], 0, uuidChars, cursor -= 2, 2);
            lsb >>>= 8;
        }
        uuidChars[--cursor] = 45;
        while (cursor > 19) {
            System.arraycopy(recode[(int)(lsb & 0xFFL)], 0, uuidChars, cursor -= 2, 2);
            lsb >>>= 8;
        }
        uuidChars[--cursor] = 45;
        while (cursor > 14) {
            System.arraycopy(recode[(int)(msb & 0xFFL)], 0, uuidChars, cursor -= 2, 2);
            msb >>>= 8;
        }
        uuidChars[--cursor] = 45;
        while (cursor > 9) {
            System.arraycopy(recode[(int)(msb & 0xFFL)], 0, uuidChars, cursor -= 2, 2);
            msb >>>= 8;
        }
        uuidChars[--cursor] = 45;
        while (cursor > 0) {
            System.arraycopy(recode[(int)(msb & 0xFFL)], 0, uuidChars, cursor -= 2, 2);
            msb >>>= 8;
        }
        return new String(uuidChars);
    }

    public static java.util.UUID random() {
        return uuidGenerator.generate();
    }
}

