/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Version {
    public final String BUILD_ID;
    public final String BUILD_NUMBER;
    public final String MAJOR_VERSION;
    public final String REVISION;
    public static final Version RUNTIME_VERSION = Version.create(Version.class.getResourceAsStream("/version.properties"));

    private Version(String buildId, String buildVersion, String majorVersion, String revision) {
        this.BUILD_ID = this.fixNull(buildId);
        this.BUILD_NUMBER = this.fixNull(buildVersion);
        this.MAJOR_VERSION = this.fixNull(majorVersion);
        this.REVISION = this.fixNull(revision);
    }

    public static Version create(InputStream is) {
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Version(props.getProperty("build-id"), props.getProperty("build-version"), props.getProperty("major-version"), props.getProperty("revision"));
    }

    private String fixNull(String v) {
        if (v == null) {
            return "unknown";
        }
        return v;
    }

    public String toString() {
        return this.MAJOR_VERSION + " (build: " + this.BUILD_ID + ") revision#" + this.REVISION;
    }
}

