/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.node;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.component.LifecycleComponent;
import io.gravitee.common.node.Node;
import io.gravitee.common.service.AbstractService;
import io.gravitee.common.util.ListReverser;
import io.gravitee.common.util.Version;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractNode
extends AbstractService<Node>
implements Node,
ApplicationContextAware {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected ApplicationContext applicationContext;

    @Override
    protected void doStart() throws Exception {
        this.LOGGER.info("{} is now starting...", (Object)this.name());
        long startTime = System.currentTimeMillis();
        List<Class<? extends LifecycleComponent>> components = this.getLifecycleComponents();
        for (Class<? extends LifecycleComponent> componentClass : components) {
            this.LOGGER.info("\tStarting component: {}", (Object)componentClass.getSimpleName());
            try {
                LifecycleComponent lifecyclecomponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                lifecyclecomponent.start();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurs while starting component {}", (Object)componentClass.getSimpleName(), (Object)e);
                throw e;
            }
        }
        long endTime = System.currentTimeMillis();
        String processId = ManagementFactory.getRuntimeMXBean().getName();
        if (processId.contains("@")) {
            processId = processId.split("@")[0];
        }
        this.LOGGER.info("{} id[{}] version[{}] pid[{}] build[{}#{}] jvm[{}/{}/{}] started in {} ms.", new Object[]{this.name(), this.id(), Version.RUNTIME_VERSION.MAJOR_VERSION, processId, Version.RUNTIME_VERSION.BUILD_NUMBER, Version.RUNTIME_VERSION.REVISION, ManagementFactory.getRuntimeMXBean().getVmVendor(), ManagementFactory.getRuntimeMXBean().getVmName(), ManagementFactory.getRuntimeMXBean().getVmVersion(), endTime - startTime});
    }

    @Override
    protected void doStop() throws Exception {
        this.LOGGER.info("{} is stopping", (Object)this.name());
        ListReverser<Class<? extends LifecycleComponent>> components = new ListReverser<Class<? extends LifecycleComponent>>(this.getLifecycleComponents());
        for (Class<? extends LifecycleComponent> componentClass : components) {
            try {
                LifecycleComponent lifecyclecomponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                if (lifecyclecomponent.lifecycleState() != Lifecycle.State.STARTED) continue;
                this.LOGGER.info("\tStopping component: {}", (Object)componentClass.getSimpleName());
                lifecyclecomponent.stop();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurs while stopping component {}", (Object)componentClass.getSimpleName(), (Object)e);
            }
        }
        this.LOGGER.info("{} stopped", (Object)this.name());
    }

    @Override
    public abstract String name();

    protected abstract List<Class<? extends LifecycleComponent>> getLifecycleComponents();

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

