/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.event.impl;

import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.common.event.impl.SimpleEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerImpl
implements EventManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventManagerImpl.class);
    private Map<ComparableEventType, Set<EventListenerWrapper>> listenersMap = new TreeMap<ComparableEventType, Set<EventListenerWrapper>>();

    @Override
    public void publishEvent(Enum type, Object content) {
        this.publishEvent(new SimpleEvent<Enum, Object>(type, content));
    }

    @Override
    public void publishEvent(Event event) {
        LOGGER.debug("Publish event {} - {}", event.type(), event.content());
        Set<EventListenerWrapper> listeners = this.getEventListeners(event.type().getClass());
        for (EventListenerWrapper listener : listeners) {
            listener.eventListener().onEvent(event);
        }
    }

    @Override
    public <T extends Enum> void subscribeForEvents(EventListener<T, ?> eventListener, T ... events) {
        for (T event : events) {
            this.addEventListener(eventListener, event.getClass(), Arrays.asList(events));
        }
    }

    @Override
    public <T extends Enum> void subscribeForEvents(EventListener<T, ?> eventListener, Class<T> events) {
        this.addEventListener(eventListener, events, EnumSet.allOf(events));
    }

    private <T extends Enum> void addEventListener(EventListener<T, ?> eventListener, Class<T> enumClass, Collection<T> events) {
        LOGGER.info("Register new listener {} for event type {}", (Object)eventListener.getClass().getSimpleName(), enumClass);
        Set<EventListenerWrapper> listeners = this.getEventListeners(enumClass);
        listeners.add(new EventListenerWrapper<T>(eventListener, events));
    }

    private <T extends Enum> Set<EventListenerWrapper> getEventListeners(Class<T> eventType) {
        Set<EventListenerWrapper> listeners = this.listenersMap.get(new ComparableEventType<T>(eventType));
        if (listeners == null) {
            listeners = new HashSet<EventListenerWrapper>();
            this.listenersMap.put(new ComparableEventType<T>(eventType), listeners);
        }
        return listeners;
    }

    private class ComparableEventType<T>
    implements Comparable<ComparableEventType<T>> {
        private static final int HASH = 623;
        private final Class<? extends T> wrappedClass;

        public ComparableEventType(Class<? extends T> wrappedClass) {
            this.wrappedClass = wrappedClass;
        }

        @Override
        public int compareTo(ComparableEventType<T> o) {
            return this.wrappedClass.getCanonicalName().compareTo(o.wrappedClass.getCanonicalName());
        }

        public int hashCode() {
            return 623 + (this.wrappedClass != null ? this.wrappedClass.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ComparableEventType)) {
                return false;
            }
            return this.compareTo((ComparableEventType)o) == 0;
        }
    }

    private class EventListenerWrapper<T extends Enum> {
        private final EventListener<T, ?> eventListener;
        private final Set<T> events;

        public EventListenerWrapper(EventListener<T, ?> eventListener, Collection<T> events) {
            this.eventListener = eventListener;
            this.events = new HashSet<T>(events);
        }

        public EventListener<T, ?> eventListener() {
            return this.eventListener;
        }

        public Set<T> events() {
            return this.events;
        }
    }
}

