/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.definition.model;

import io.gravitee.definition.model.EndpointType;
import java.util.List;

public abstract class Endpoint {
    public static int DEFAULT_WEIGHT = 1;
    private String name;
    private String target;
    private int weight = DEFAULT_WEIGHT;
    private boolean backup;
    private Status status = Status.UP;
    private List<String> tenants;
    private final EndpointType type;
    private Boolean inherit;

    public Endpoint(EndpointType type, String name, String target) {
        this.type = type;
        this.name = name;
        this.target = target;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public void setBackup(boolean backup) {
        this.backup = backup;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<String> getTenants() {
        return this.tenants;
    }

    public void setTenants(List<String> tenants) {
        this.tenants = tenants;
    }

    public EndpointType getType() {
        return this.type;
    }

    public Boolean getInherit() {
        return this.inherit;
    }

    public void setInherit(Boolean inherit) {
        this.inherit = inherit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return this.name.equals(endpoint.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum Status {
        UP(3),
        DOWN(0),
        TRANSITIONALLY_DOWN(1),
        TRANSITIONALLY_UP(2);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public boolean isDown() {
            return this == DOWN || this == TRANSITIONALLY_UP;
        }
    }
}

