/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.proxy.builder;

import io.gravitee.common.http.HttpHeaders;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.proxy.ProxyRequest;
import io.gravitee.gateway.api.proxy.builder.ProxyRequestImpl;
import io.gravitee.gateway.api.proxy.ws.WebSocketProxyRequestImpl;
import java.net.URI;
import java.util.Map;

public class ProxyRequestBuilder {
    private URI uri;
    private Map<String, String> parameters;
    private HttpMethod method;
    private String rawMethod;
    private HttpHeaders headers;
    private Request request;

    private ProxyRequestBuilder(Request request) {
        this.request = request;
    }

    public static ProxyRequestBuilder from(Request request) {
        return new ProxyRequestBuilder(request);
    }

    public ProxyRequestBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ProxyRequestBuilder parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ProxyRequestBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public ProxyRequestBuilder rawMethod(String rawMethod) {
        this.rawMethod = rawMethod;
        return this;
    }

    public ProxyRequestBuilder headers(HttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public ProxyRequest build() {
        ProxyRequestImpl proxyRequest = !this.request.isWebSocket() ? new ProxyRequestImpl(this.request.metrics()) : new WebSocketProxyRequestImpl(this.request.websocket(), this.request.metrics());
        proxyRequest.setUri(this.uri);
        proxyRequest.setMethod(this.method);
        proxyRequest.setRawMethod(this.rawMethod);
        proxyRequest.setParameters(this.parameters);
        proxyRequest.setHeaders(this.headers);
        return proxyRequest;
    }
}

