/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.http.stream;

import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableResponseStreamBuilder;
import io.gravitee.gateway.api.http.stream.TransformableSourceStream;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformableResponseStream
extends TransformableSourceStream<Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformableResponseStream.class);

    TransformableResponseStream(TransformableResponseStreamBuilder builder) {
        super(builder);
    }

    @Override
    public void end() {
        Buffer content;
        try {
            content = this.transform().apply(this.buffer);
            ((Response)this.source).headers().remove((Object)"Transfer-Encoding");
            ((Response)this.source).headers().set("Content-Length", Integer.toString(content.length()));
            String contentType = this.contentType();
            if (contentType != null && !contentType.isEmpty()) {
                ((Response)this.source).headers().set("Content-Type", contentType);
            }
        }
        catch (TransformationException tex) {
            LOGGER.error("Unexpected error while transforming response content", (Throwable)tex);
            content = Buffer.buffer(tex.getMessage());
            ((Response)this.source).status(500);
            ((Response)this.source).headers().set("Content-Type", "text/plain");
            ((Response)this.source).headers().set("Connection", "close");
        }
        super.flush(content);
        super.end();
    }
}

