/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.http.stream;

import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableRequestStreamBuilder;
import io.gravitee.gateway.api.http.stream.TransformableSourceStream;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformableRequestStream
extends TransformableSourceStream<Request> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformableRequestStream.class);

    TransformableRequestStream(TransformableRequestStreamBuilder builder) {
        super(builder);
    }

    @Override
    public void end() {
        Buffer content;
        try {
            content = this.transform().apply(this.buffer);
            ((Request)this.source).headers().remove((Object)"Transfer-Encoding");
            ((Request)this.source).headers().set("Content-Length", Integer.toString(content.length()));
            String contentType = this.contentType();
            if (contentType != null && !contentType.isEmpty()) {
                ((Request)this.source).headers().set("Content-Type", contentType);
            }
        }
        catch (TransformationException tex) {
            LOGGER.error("Unexpected error while transforming request content", (Throwable)tex);
            content = Buffer.buffer(tex.getMessage());
        }
        super.flush(content);
        super.end();
    }
}

