/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import io.gravitee.common.service.AbstractService;
import io.gravitee.node.api.Node;
import io.gravitee.node.container.Container;
import java.io.File;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class AbstractContainer
extends AbstractService<Container>
implements Container {
    private static final String GRAVITEE_HOME_PROPERTY = "gravitee.home";
    private static final String GRAVITEE_CONFIGURATION_PROPERTY = "gravitee.conf";
    protected boolean stopped = false;

    public AbstractContainer() {
        this.initialize();
    }

    protected void initialize() {
        this.initializeEnvironment();
        this.initializeLogging();
    }

    protected void initializeEnvironment() {
        String graviteeConfiguration = System.getProperty(GRAVITEE_CONFIGURATION_PROPERTY);
        if (graviteeConfiguration == null || graviteeConfiguration.isEmpty()) {
            String graviteeHome = System.getProperty(GRAVITEE_HOME_PROPERTY);
            System.setProperty(GRAVITEE_CONFIGURATION_PROPERTY, graviteeHome + File.separator + "config" + File.separator + "gravitee.yml");
        }
    }

    protected void initializeLogging() {
        String graviteeHome = System.getProperty(GRAVITEE_HOME_PROPERTY);
        String logbackConfiguration = graviteeHome + File.separator + "config" + File.separator + "logback.xml";
        File logbackConfigurationfile = new File(logbackConfiguration);
        if (logbackConfigurationfile.exists()) {
            System.setProperty("logback.configurationFile", logbackConfigurationfile.getAbsolutePath());
            StaticLoggerBinder loggerBinder = StaticLoggerBinder.getSingleton();
            LoggerContext loggerContext = (LoggerContext)loggerBinder.getLoggerFactory();
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            try {
                configurator.doConfigure(logbackConfigurationfile);
            }
            catch (JoranException e) {
                LoggerFactory.getLogger(this.getClass()).error("An error occurs while initializing logging system", (Throwable)e);
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
        }
    }

    protected void doStart() throws Exception {
        LoggerFactory.getLogger(AbstractContainer.class).info("Starting {}...", (Object)this.name());
        try {
            Node node = this.node();
            node.start();
            ContainerShutdownHook shutdownHook = new ContainerShutdownHook(node);
            shutdownHook.setName("graviteeio-finalizer");
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(this.getClass()).error("An unexpected error occurs while starting {}", (Object)this.name(), (Object)ex);
            this.stop();
        }
    }

    protected void doStop() throws Exception {
        if (!this.stopped) {
            LoggerFactory.getLogger(this.getClass()).info("Shutting-down {}...", (Object)this.name());
            try {
                this.node().stop();
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Unexpected error", (Throwable)ex);
            }
            finally {
                this.stopped = true;
            }
        }
    }

    private class ContainerShutdownHook
    extends Thread {
        private final Node node;

        private ContainerShutdownHook(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            if (this.node != null) {
                try {
                    AbstractContainer.this.stop();
                }
                catch (Exception ex) {
                    LoggerFactory.getLogger(this.getClass()).error("Unexpected error while stopping {}", (Object)AbstractContainer.this.name(), (Object)ex);
                }
            }
        }
    }
}

