/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.discovery.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginType;
import io.gravitee.plugin.discovery.ServiceDiscoveryPlugin;
import io.gravitee.plugin.discovery.internal.ServiceDiscoveryConfigurationClassFinder;
import io.gravitee.plugin.discovery.internal.ServiceDiscoveryPluginImpl;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceDiscoveryPluginHandler
extends AbstractSimplePluginHandler<ServiceDiscoveryPlugin> {
    @Autowired
    private ConfigurablePluginManager<ServiceDiscoveryPlugin> serviceDiscoveryPluginManager;

    public boolean canHandle(Plugin plugin) {
        return PluginType.SERVICE_DISCOVERY == plugin.type();
    }

    protected String type() {
        return "service-discoveries";
    }

    protected ServiceDiscoveryPlugin create(Plugin plugin, Class<?> pluginClass) {
        ServiceDiscoveryPluginImpl serviceDiscoveryPlugin = new ServiceDiscoveryPluginImpl(plugin, pluginClass);
        serviceDiscoveryPlugin.setConfiguration(new ServiceDiscoveryConfigurationClassFinder().lookupFirst(pluginClass));
        return serviceDiscoveryPlugin;
    }

    protected void register(ServiceDiscoveryPlugin plugin) {
        this.serviceDiscoveryPluginManager.register((Plugin)plugin);
    }

    protected ClassLoader getClassLoader(Plugin plugin) throws Exception {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

