/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.policy.api;

public interface PolicyResult {
    public boolean isFailure();

    public int httpStatusCode();

    public String message();

    public String contentType();

    public static PolicyResult build(final boolean isFailure, final int statusCode, final String message, final String contentType) {
        return new PolicyResult(){

            @Override
            public boolean isFailure() {
                return isFailure;
            }

            @Override
            public int httpStatusCode() {
                return statusCode;
            }

            @Override
            public String message() {
                return message;
            }

            @Override
            public String contentType() {
                return contentType;
            }
        };
    }

    public static PolicyResult build(boolean isFailure, int statusCode, String message) {
        return PolicyResult.build(isFailure, statusCode, message, "text/plain");
    }

    public static PolicyResult failure(int statusCode, String message) {
        return PolicyResult.build(true, statusCode, message);
    }

    public static PolicyResult failure(String message) {
        return PolicyResult.failure(500, message);
    }

    public static PolicyResult failure(int statusCode, String message, String contentType) {
        return PolicyResult.build(true, statusCode, message, contentType);
    }

    public static PolicyResult failure(String message, String contentType) {
        return PolicyResult.failure(500, message, contentType);
    }
}

