/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.trust;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.grpc.xds.internal.security.trust.CertificateUtils;
import io.grpc.xds.internal.security.trust.XdsX509TrustManager;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.DataSource;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

public final class XdsTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Logger logger = Logger.getLogger(XdsTrustManagerFactory.class.getName());
    private XdsX509TrustManager xdsX509TrustManager;

    public XdsTrustManagerFactory(CertificateValidationContext certificateValidationContext) throws CertificateException, IOException, CertStoreException {
        this(XdsTrustManagerFactory.getTrustedCaFromCertContext(certificateValidationContext), certificateValidationContext, false);
    }

    public XdsTrustManagerFactory(X509Certificate[] certs, CertificateValidationContext staticCertificateValidationContext) throws CertStoreException {
        this(certs, staticCertificateValidationContext, true);
    }

    private XdsTrustManagerFactory(X509Certificate[] certs, CertificateValidationContext certificateValidationContext, boolean validationContextIsStatic) throws CertStoreException {
        if (validationContextIsStatic) {
            Preconditions.checkArgument((certificateValidationContext == null || !certificateValidationContext.hasTrustedCa() ? 1 : 0) != 0, (Object)"only static certificateValidationContext expected");
        }
        this.xdsX509TrustManager = XdsTrustManagerFactory.createSdsX509TrustManager(certs, certificateValidationContext);
    }

    private static X509Certificate[] getTrustedCaFromCertContext(CertificateValidationContext certificateValidationContext) throws CertificateException, IOException {
        DataSource.SpecifierCase specifierCase = certificateValidationContext.getTrustedCa().getSpecifierCase();
        if (specifierCase == DataSource.SpecifierCase.FILENAME) {
            String certsFile = certificateValidationContext.getTrustedCa().getFilename();
            Preconditions.checkState((!Strings.isNullOrEmpty((String)certsFile) ? 1 : 0) != 0, (Object)"trustedCa.file-name in certificateValidationContext cannot be empty");
            return CertificateUtils.toX509Certificates(new File(certsFile));
        }
        if (specifierCase == DataSource.SpecifierCase.INLINE_BYTES) {
            try (InputStream is = certificateValidationContext.getTrustedCa().getInlineBytes().newInput();){
                X509Certificate[] x509CertificateArray = CertificateUtils.toX509Certificates(is);
                return x509CertificateArray;
            }
        }
        throw new IllegalArgumentException("Not supported: " + (Object)((Object)specifierCase));
    }

    @VisibleForTesting
    static XdsX509TrustManager createSdsX509TrustManager(X509Certificate[] certs, CertificateValidationContext certContext) throws CertStoreException {
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, null);
            int i = 1;
            for (X509Certificate cert : certs) {
                ks.setCertificateEntry("alias" + i, cert);
                ++i;
            }
            tmf.init(ks);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.log(Level.SEVERE, "createSdsX509TrustManager", e);
            throw new CertStoreException(e);
        }
        TrustManager[] tms = tmf.getTrustManagers();
        X509ExtendedTrustManager myDelegate = null;
        if (tms != null) {
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                myDelegate = (X509ExtendedTrustManager)tm;
                break;
            }
        }
        if (myDelegate == null) {
            throw new CertStoreException("Native X509 TrustManager not found.");
        }
        return new XdsX509TrustManager(certContext, myDelegate);
    }

    protected void engineInit(KeyStore keyStore) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.xdsX509TrustManager};
    }
}

