/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.example.ircplugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.schwering.irc.lib.ssl.SSLDefaultTrustManager;
import org.schwering.irc.lib.ssl.SSLIRCConnection;
import org.schwering.irc.lib.ssl.SSLTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRCConnectionHandler
extends IRCEventAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(IRCConnectionHandler.class);
    private IRCConnection connection;
    LinkedBlockingQueue<Object> messageQueue = new LinkedBlockingQueue();

    public static IRCConnectionHandler create(boolean useSSL, Map<String, String> settings) throws IOException {
        SSLIRCConnection connection;
        String host = settings.get("host");
        String pass = settings.get("password");
        String nick = settings.get("nickname");
        String username = settings.get("username");
        String realname = settings.get("realname");
        String portsString = settings.get("ports");
        ArrayList<Integer> portsList = new ArrayList<Integer>();
        if (host == null || nick == null) {
            return null;
        }
        if (portsString == null) {
            if (useSSL) {
                portsList.add(6697);
            } else {
                portsList.add(6667);
            }
        } else {
            for (String port : portsString.split(",")) {
                portsList.add(Integer.parseInt(port.trim()));
            }
        }
        int[] ports = new int[portsList.size()];
        for (int i = 0; i < ports.length; ++i) {
            ports[i] = (Integer)portsList.get(i);
        }
        IRCConnectionHandler answer = new IRCConnectionHandler();
        if (useSSL) {
            connection = new SSLIRCConnection(host, ports, pass, nick, username, realname);
            connection.addTrustManager((SSLTrustManager)new SSLDefaultTrustManager());
        } else {
            connection = new IRCConnection(host, ports, pass, nick, username, realname);
        }
        connection.addIRCEventListener((IRCEventListener)answer);
        answer.setConnection((IRCConnection)connection);
        connection.setDaemon(true);
        connection.setColors(false);
        connection.setPong(true);
        connection.connect();
        return answer;
    }

    protected IRCConnectionHandler() {
    }

    public void destroy() {
        if (this.isConnected()) {
            this.connection.doQuit();
        }
    }

    public boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.isConnected();
    }

    public String toString() {
        return "ConnectionHandler connection to: " + this.connection.getHost() + " nick: " + this.connection.getNick() + " connected: " + this.connection.isConnected() + " alive: " + this.connection.isAlive();
    }

    public void setConnection(IRCConnection connection) {
        this.connection = connection;
    }

    public void send(String command) {
        this.connection.send(command);
    }

    public List<Object> fetch() {
        ArrayList<Object> answer = new ArrayList<Object>();
        this.messageQueue.drainTo(answer);
        return answer;
    }

    protected Map<Object, Object> getMap(Object ... args) {
        HashMap<Object, Object> answer = new HashMap<Object, Object>();
        if (args.length % 2 != 0) {
            answer.put("invalid-args", args);
            return answer;
        }
        for (int i = 0; i < args.length; i += 2) {
            answer.put(args[i], args[i + 1]);
        }
        return answer;
    }

    private void putMessage(Map message) {
        LOG.debug("Putting \"" + message + "\" onto message queue");
        try {
            this.messageQueue.put(message);
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted exception putting \"" + message + "\" into queue for connection " + this.connection.getNick() + "@" + this.connection.getHost(), (Throwable)e);
        }
    }

    public void onError(String msg) {
        Map message = this.getMap(new Object[]{"type", "error", "message", msg});
        this.putMessage(message);
    }

    public void onError(int num, String msg) {
        Map message = this.getMap(new Object[]{"type", "error", "num", num, "message", msg});
        this.putMessage(message);
    }

    public void onInvite(String chan, IRCUser user, String passiveNick) {
        Map message = this.getMap(new Object[]{"type", "invite", "chan", chan, "user", user, "passiveNick", passiveNick});
        this.putMessage(message);
    }

    public void onJoin(String chan, IRCUser user) {
        Map message = this.getMap(new Object[]{"type", "join", "chan", chan, "user", user});
        this.putMessage(message);
    }

    public void onKick(String chan, IRCUser user, String passiveNick, String msg) {
        Map message = this.getMap(new Object[]{"type", "kick", "chan", chan, "user", user, "passiveNick", passiveNick, "message", msg});
        this.putMessage(message);
    }

    public void onMode(String chan, IRCUser user, IRCModeParser modeParser) {
        Map message = this.getMap(new Object[]{"type", "mode", "chan", chan, "user", user, "modeParser", modeParser});
        this.putMessage(message);
    }

    public void onMode(IRCUser user, String passiveNick, String mode) {
        Map message = this.getMap(new Object[]{"type", "mode", "user", user, "passiveNick", passiveNick, "mode", mode});
        this.putMessage(message);
    }

    public void onNick(IRCUser user, String newNick) {
        Map message = this.getMap(new Object[]{"type", "nick", "user", user, "newNick", newNick});
        this.putMessage(message);
    }

    public void onNotice(String target, IRCUser user, String msg) {
        Map message = this.getMap(new Object[]{"type", "notice", "target", target, "user", user, "message", msg});
        this.putMessage(message);
    }

    public void onPart(String chan, IRCUser user, String msg) {
        Map message = this.getMap(new Object[]{"type", "part", "chan", chan, "user", user, "message", msg});
        this.putMessage(message);
    }

    public void onPrivmsg(String target, IRCUser user, String msg) {
        Map message = this.getMap(new Object[]{"type", "privmsg", "target", target, "user", user, "message", msg});
        this.putMessage(message);
    }

    public void onQuit(IRCUser user, String msg) {
        Map message = this.getMap(new Object[]{"type", "quit", "user", user, "message", msg});
        this.putMessage(message);
    }

    public void onReply(int num, String value, String msg) {
        Map message = this.getMap(new Object[]{"type", "reply", "num", num, "value", value, "message", msg});
        this.putMessage(message);
    }

    public void onTopic(String chan, IRCUser user, String topic) {
        Map message = this.getMap(new Object[]{"type", "topic", "chan", chan, "user", user, "topic", topic});
        this.putMessage(message);
    }

    public void unknown(String prefix, String command, String middle, String trailing) {
        Map message = this.getMap(new Object[]{"type", "unknown", "prefix", prefix, "command", command, "middle", middle, "trailing", trailing});
        this.putMessage(message);
    }

    public void onRegistered() {
        Map message = this.getMap(new Object[]{"type", "registered"});
        this.putMessage(message);
    }

    public void onDisconnected() {
        Map message = this.getMap(new Object[]{"type", "disconnected"});
        this.putMessage(message);
    }

    public void onPing(String ping) {
        Map message = this.getMap(new Object[]{"type", "ping", "ping", ping});
        this.putMessage(message);
    }

    public void back() {
        this.connection.doAway();
    }

    public void away(String message) {
        this.connection.doAway(message);
    }

    public void join(String channel) {
        this.connection.doJoin(channel);
    }

    public void join(String channel, String key) {
        this.connection.doJoin(channel, key);
    }

    public void kick(String channel, String nick) {
        this.connection.doKick(channel, nick);
    }

    public void kick(String channel, String nick, String message) {
        this.connection.doKick(channel, nick, message);
    }

    public void list() {
        this.connection.doList();
    }

    public void list(String channels) {
        this.connection.doList(channels);
    }

    public void names() {
        this.connection.doNames();
    }

    public void names(String channels) {
        this.connection.doNames(channels);
    }

    public void nick(String nick) {
        this.connection.doNick(nick);
    }

    public void notice(String target, String message) {
        this.connection.doNotice(target, message);
    }

    public void part(String channel) {
        this.connection.doPart(channel);
    }

    public void part(String channel, String message) {
        this.connection.doPart(channel, message);
    }

    public void topic(String channel) {
        this.connection.doTopic(channel);
    }

    public void changeTopic(String channel, String topic) {
        this.connection.doTopic(channel, topic);
    }

    public void getUserHost(String nicknames) {
        this.connection.doUserhost(nicknames);
    }

    public void message(String target, String message) {
        this.connection.doPrivmsg(target, message);
    }

    public void whois(String nick) {
        this.connection.doWhois(nick);
    }

    public void whowas(String nick) {
        this.connection.doWhowas(nick);
    }

    public void who(String nick) {
        this.connection.doWho(nick);
    }
}

