/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.example.ircplugin;

import io.hawt.example.ircplugin.IRCConnectionHandler;
import io.hawt.example.ircplugin.IRCHandlerMBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRCHandler
implements IRCHandlerMBean {
    private static final Logger LOG = LoggerFactory.getLogger(IRCHandler.class);
    Map<Subject, IRCConnectionHandler> connections;
    private MBeanServer mBeanServer;
    private ObjectName objectName;

    public void init() {
        this.connections = new ConcurrentHashMap();
        if (this.objectName == null) {
            try {
                this.objectName = this.getObjectName();
            }
            catch (Exception e) {
                LOG.warn("Failed to create object name: ", (Throwable)e);
                throw new RuntimeException("Failed to create object name: ", e);
            }
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                try {
                    this.mBeanServer.unregisterMBean(this.objectName);
                    this.mBeanServer.registerMBean(this, this.objectName);
                }
                catch (Exception e) {
                    LOG.warn("Failed to register mbean: ", (Throwable)e);
                    throw new RuntimeException("Failed to register mbean: ", e);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to register mbean: ", (Throwable)e);
                throw new RuntimeException("Failed to register mbean: ", e);
            }
        }
    }

    public void connect(Map<String, String> settings) {
        Boolean useSSL;
        Subject subject = this.getSubject();
        IRCConnectionHandler connection = (IRCConnectionHandler)this.connections.remove(subject);
        if (connection != null) {
            connection.destroy();
        }
        if ((useSSL = Boolean.valueOf(settings.get("useSSL"))) == null) {
            useSSL = Boolean.FALSE;
        }
        try {
            connection = IRCConnectionHandler.create((boolean)useSSL, settings);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create connection: ", e);
        }
        if (connection == null) {
            throw new RuntimeException("Failed to create connection, please ensure both a host and nickname are specified");
        }
        System.out.println("Created connection: " + connection);
        this.connections.put(subject, connection);
    }

    public List<Object> fetch() {
        return this.getConnection().fetch();
    }

    public void send(String command) {
        this.getConnection().send(command);
    }

    public boolean connected() {
        Subject subject = this.getSubject();
        IRCConnectionHandler connection = (IRCConnectionHandler)this.connections.get(subject);
        if (connection == null) {
            return false;
        }
        return connection.isConnected();
    }

    public void disconnect() {
        Subject subject = this.getSubject();
        IRCConnectionHandler connection = (IRCConnectionHandler)this.connections.remove(subject);
        if (connection != null) {
            connection.destroy();
        }
    }

    protected Subject getSubject() {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            throw new RuntimeException("Subject is not available, user would not be able to be associated with a connection");
        }
        return subject;
    }

    protected IRCConnectionHandler getConnection() {
        Subject subject = this.getSubject();
        IRCConnectionHandler answer = (IRCConnectionHandler)this.connections.get(subject);
        if (answer == null) {
            throw new RuntimeException("No connection");
        }
        return answer;
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName("hawtio:type=IRCHandler");
    }

    public void destroy() {
        for (Subject subject : this.connections.keySet()) {
            IRCConnectionHandler connection = (IRCConnectionHandler)this.connections.get(subject);
            if (connection == null) continue;
            connection.destroy();
        }
        this.connections.clear();
    }

    public void back() {
        this.getConnection().back();
    }

    public void away(String message) {
        this.getConnection().away(message);
    }

    public void join(String channel) {
        this.getConnection().join(channel);
    }

    public void join(String channel, String key) {
        this.getConnection().join(channel, key);
    }

    public void kick(String channel, String nick) {
        this.getConnection().kick(channel, nick);
    }

    public void kick(String channel, String nick, String message) {
        this.getConnection().kick(channel, nick, message);
    }

    public void list() {
        this.getConnection().list();
    }

    public void list(String channels) {
        this.getConnection().list(channels);
    }

    public void names() {
        this.getConnection().names();
    }

    public void names(String channels) {
        this.getConnection().names(channels);
    }

    public void nick(String nick) {
        this.getConnection().nick(nick);
    }

    public void notice(String target, String message) {
        this.getConnection().notice(target, message);
    }

    public void part(String channel) {
        this.getConnection().part(channel);
    }

    public void part(String channel, String message) {
        this.getConnection().part(channel, message);
    }

    public void topic(String channel) {
        this.getConnection().topic(channel);
    }

    public void changeTopic(String channel, String topic) {
        this.getConnection().changeTopic(channel, topic);
    }

    public void getUserHost(String nicknames) {
        this.getConnection().getUserHost(nicknames);
    }

    public void who(String nick) {
        this.getConnection().who(nick);
    }

    public void whowas(String nick) {
        this.getConnection().whowas(nick);
    }

    public void whois(String nick) {
        this.getConnection().whois(nick);
    }

    public void message(String target, String message) {
        this.getConnection().message(target, message);
    }
}

