/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.ansi;

import io.helidon.build.common.RichTextRenderer;
import io.helidon.build.common.ansi.AnsiTextProvider;
import io.helidon.build.common.ansi.AnsiTextStyle;
import io.helidon.build.common.ansi.AnsiTextStyles;
import io.helidon.build.common.logging.LogFormatter;
import io.helidon.build.common.logging.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumMap;
import java.util.Map;

final class AnsiLogFormatter
extends LogFormatter {
    private static final String EOL = System.getProperty("line.separator");
    private final String warnPrefix;
    private final String errorPrefix;
    private final Map<LogLevel, AnsiTextStyles> stylesByLevel;

    private AnsiLogFormatter() {
        boolean stylesEnabled = AnsiTextProvider.isEnabled();
        this.warnPrefix = stylesEnabled ? AnsiTextStyles.BoldYellow.apply("warning: ") : "WARNING: ";
        this.errorPrefix = stylesEnabled ? AnsiTextStyles.Red.apply("error: ") : "ERROR: ";
        this.stylesByLevel = new EnumMap<LogLevel, AnsiTextStyles>(LogLevel.class);
        this.stylesByLevel.put(LogLevel.DEBUG, AnsiTextStyles.Italic);
        this.stylesByLevel.put(LogLevel.VERBOSE, AnsiTextStyles.Plain);
        this.stylesByLevel.put(LogLevel.INFO, AnsiTextStyles.Plain);
        this.stylesByLevel.put(LogLevel.WARN, AnsiTextStyles.Plain);
        this.stylesByLevel.put(LogLevel.ERROR, AnsiTextStyles.ItalicRed);
    }

    public String formatEntry(LogLevel level, Throwable thrown, String message, Object ... args) {
        String entry = this.toStyled(level, thrown, message, args);
        switch (level) {
            case DEBUG: 
            case VERBOSE: 
            case INFO: {
                return entry;
            }
            case WARN: {
                return this.warnPrefix + entry;
            }
            case ERROR: {
                return this.errorPrefix + entry;
            }
        }
        throw new Error();
    }

    private String toStyled(LogLevel level, Throwable thrown, String message, Object ... args) {
        String rendered = RichTextRenderer.render((String)message, (Object[])args);
        String styled = this.toStyled(level, rendered);
        String trace = this.toStackTrace(thrown, level);
        if (trace == null) {
            return styled;
        }
        if (styled.isEmpty()) {
            return trace;
        }
        return styled + EOL + trace;
    }

    private String toStyled(LogLevel level, String message) {
        return AnsiTextStyle.isStyled(message) ? message : this.styleEntry(level, message);
    }

    private String toStackTrace(Throwable thrown, LogLevel level) {
        if (thrown != null) {
            if (AnsiLogFormatter.isDebug((LogLevel)level)) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                try {
                    thrown.printStackTrace(pw);
                    String string = this.styleEntry(LogLevel.DEBUG, sw.toString());
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {}
                }
            } else if (AnsiLogFormatter.isVerbose((LogLevel)level)) {
                return this.styleEntry(LogLevel.DEBUG, thrown.toString());
            }
        }
        return null;
    }

    private String styleEntry(LogLevel level, String entry) {
        AnsiTextStyles style = this.stylesByLevel.get(level);
        return style == AnsiTextStyles.Plain ? entry : style.apply(entry);
    }

    static final class Holder {
        static final AnsiLogFormatter INSTANCE = new AnsiLogFormatter();

        Holder() {
        }
    }
}

