/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.maven.logging;

import io.helidon.build.common.RichTextRenderer;
import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.common.logging.LogWriter;
import io.helidon.build.common.logging.SystemLogWriter;
import io.helidon.build.common.maven.logging.PlexusLoggerHolder;
import org.codehaus.plexus.logging.Logger;

public class PlexusLogWriter
extends LogWriter {
    public void writeEntry(LogLevel level, Throwable thrown, String message, Object ... args) {
        Logger logger = PlexusLoggerHolder.REF.get();
        if (logger == null) {
            SystemLogWriter.INSTANCE.writeEntry(level, thrown, message, args);
            return;
        }
        switch (level) {
            case DEBUG: 
            case VERBOSE: {
                if (!logger.isDebugEnabled()) break;
                String entry = this.renderEntry(message, args);
                if (thrown == null) {
                    logger.debug(entry);
                    break;
                }
                logger.debug(entry, thrown);
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) break;
                String entry = this.renderEntry(message, args);
                if (thrown == null) {
                    logger.info(entry);
                    break;
                }
                logger.info(entry, thrown);
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) break;
                String entry = this.renderEntry(message, args);
                if (thrown == null) {
                    logger.warn(entry);
                    break;
                }
                logger.warn(entry, thrown);
                break;
            }
            case ERROR: {
                if (!logger.isErrorEnabled()) break;
                String entry = this.renderEntry(message, args);
                if (thrown == null) {
                    logger.error(entry);
                    break;
                }
                logger.error(entry, thrown);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private String renderEntry(String message, Object ... args) {
        String entry = RichTextRenderer.render((String)message, (Object[])args);
        this.recordEntry(entry);
        return entry;
    }
}

