/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Maps {
    private Maps() {
    }

    public static Map<String, String> fromProperties(Properties properties) {
        Objects.requireNonNull(properties);
        HashMap<String, String> map = new HashMap<String, String>();
        properties.stringPropertyNames().forEach(k -> map.put((String)k, properties.getProperty((String)k)));
        return map;
    }

    public static Properties toProperties(Map<String, String> map) {
        Objects.requireNonNull(map);
        Properties properties = new Properties();
        map.forEach(properties::setProperty);
        return properties;
    }

    public static <T, U> Map<U, Set<T>> reverse(Map<T, U> map) {
        HashMap<Object, Set> reversed = new HashMap<Object, Set>();
        for (Map.Entry<T, U> entry : map.entrySet()) {
            reversed.computeIfAbsent(entry.getValue(), v -> new HashSet()).add(entry.getKey());
        }
        return reversed;
    }

    public static <K, V> Map<K, V> sortByValue(Map<K, V> map, Comparator<V> cmp) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue(cmp));
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V, X> Map<K, X> mapValue(Map<K, V> map, Function<V, X> mapper) {
        return Maps.mapValue(map, (k, v) -> true, mapper);
    }

    public static <K, V, X> Map<K, X> mapValue(Map<K, V> map, BiPredicate<K, V> filter, Function<V, X> mapper) {
        return map.entrySet().stream().filter(e -> filter.test(e.getKey(), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> mapper.apply(e.getValue())));
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, BiPredicate<K, V> filter) {
        return map.entrySet().stream().filter(e -> filter.test(e.getKey(), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, K key) {
        return Maps.filter(map, (k, v) -> !k.equals(key));
    }

    public static <K, V> Map<V, List<Map<K, V>>> keyedBy(List<Map<K, V>> maps, K key) {
        return maps.stream().collect(Collectors.toMap(m -> m.get(key), m -> Lists.of(Maps.filter(m, key)), Lists::addAll));
    }

    public static <K, V> Map<K, V> put(Map<K, V> map, K k, V v) {
        HashMap<K, V> res = new HashMap<K, V>();
        if (map != null) {
            res.putAll(map);
        }
        res.put(k, v);
        return res;
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> map1, Map<K, V> map2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.putAll(map1);
        map.putAll(map2);
        return map;
    }

    public static <K, V> Map<K, V> putAll(List<Map<K, V>> maps) {
        HashMap map = new HashMap();
        maps.forEach(map::putAll);
        return map;
    }

    public static <K, V> List<Map<K, V>> putAll(List<Map<K, V>> maps, Map<K, V> map1) {
        if (maps.isEmpty()) {
            return Lists.of(map1);
        }
        maps.forEach(m -> m.putAll(map1));
        return maps;
    }

    public static <K, V> Map<K, V> putIfAbsent(Map<K, V> map, K key, V value) {
        HashMap<K, V> copy = new HashMap<K, V>(map);
        copy.putIfAbsent(key, value);
        return copy;
    }

    public static <K, V> List<Map<K, V>> putIfAbsent(List<Map<K, V>> maps, K key, V value) {
        if (maps.isEmpty()) {
            return Lists.of(Maps.of(key, value));
        }
        maps.forEach(m -> m.putIfAbsent(key, value));
        return maps;
    }

    public static <K, V> Map<K, V> of(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <K, V> List<Map.Entry<K, V>> entries(Map<K, V> map) {
        return new ArrayList<Map.Entry<K, V>>(map.entrySet());
    }

    public static <K, V> Map<K, V> fromEntries(Collection<Map.Entry<K, V>> entries) {
        return Maps.fromEntries(entries.stream());
    }

    public static <K, V> Map<K, V> fromEntries(Collection<Map.Entry<K, V>> entries, BinaryOperator<V> mergeFunction) {
        return Maps.fromEntries(entries.stream(), mergeFunction);
    }

    public static <K, V> Map<K, V> fromEntries(Stream<Map.Entry<K, V>> entries) {
        return entries.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static <K, V> Map<K, V> fromEntries(Stream<Map.Entry<K, V>> entries, BinaryOperator<V> mergeFunction) {
        return entries.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, mergeFunction));
    }

    public static <K, V> Map<K, V> merge(List<Map<K, V>> maps, BinaryOperator<V> mergeFunction) {
        return Maps.fromEntries(Lists.flatMap(maps, Map::entrySet), mergeFunction);
    }

    public static <K, V> Map<K, V> merge(List<Map<K, V>> maps) {
        return Maps.fromEntries(Lists.flatMap(maps, Map::entrySet));
    }
}

