/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.logging;

import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.common.logging.LogRecorder;
import io.helidon.build.common.logging.SystemLogWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;

public abstract class LogWriter {
    private final List<LogRecorder> recorders = Collections.synchronizedList(new ArrayList());

    protected LogWriter() {
    }

    public static void write(LogLevel level, Throwable thrown, String message, Object ... args) {
        Holder.INSTANCE.writeEntry(level, thrown, message, args);
    }

    public static void addRecorder(LogRecorder recorder) {
        Holder.INSTANCE.recorders.add(recorder);
    }

    public static void removeRecorder(LogRecorder recorder) {
        Holder.INSTANCE.recorders.remove(recorder);
    }

    public abstract void writeEntry(LogLevel var1, Throwable var2, String var3, Object ... var4);

    protected final void recordEntry(String entry) {
        for (LogRecorder recorder : this.recorders) {
            recorder.addEntry(entry);
        }
    }

    static void init() throws IllegalStateException {
        if (Holder.INSTANCE == null) {
            throw new IllegalStateException("Unable to load log writer");
        }
    }

    private static final class Holder {
        static final LogWriter INSTANCE = ServiceLoader.load(LogWriter.class).findFirst().orElse(SystemLogWriter.INSTANCE);

        private Holder() {
        }
    }
}

