/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Function;

public class Diff<T> {
    private final int orig;
    private final int actual;
    private final T element;

    public Diff(int orig, int actual, T element) {
        this.orig = orig;
        this.actual = actual;
        this.element = element;
    }

    public Diff(int orig, int actual) {
        this(orig, actual, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Diff)) {
            return false;
        }
        Diff diff = (Diff)o;
        return this.orig == diff.orig && this.actual == diff.actual && Objects.equals(this.element, diff.element);
    }

    public int hashCode() {
        return Objects.hash(this.orig, this.actual, this.element);
    }

    public int actual() {
        return this.actual;
    }

    public int orig() {
        return this.orig;
    }

    public T element() {
        return this.element;
    }

    public boolean isAdd() {
        return this.orig < 0;
    }

    public boolean isRemove() {
        return this.actual < 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isAdd()) {
            sb.append("ADD(").append(this.actual);
        } else if (this.isRemove()) {
            sb.append("DEL(").append(this.orig);
        } else {
            sb.append("MOVE(").append(this.orig).append(',').append(this.actual);
        }
        if (this.element != null) {
            sb.append(',').append(this.element);
        }
        sb.append(')');
        return sb.toString();
    }

    public static <T> void apply(List<Diff<T>> diffs, List<T> target) {
        Diff.apply(diffs, target, Function.identity());
    }

    public static <T, U> void apply(List<Diff<T>> diffs, List<U> target, Function<T, U> mapper) {
        for (Diff<T> diff : diffs) {
            if (diff.isAdd()) {
                target.add(diff.actual, mapper.apply(diff.element));
                continue;
            }
            if (diff.isRemove()) {
                target.remove(diff.orig);
                continue;
            }
            U moved = target.remove(diff.orig);
            target.add(diff.actual, moved);
        }
    }

    public static <T> List<Diff<T>> diff(List<T> orig, List<T> actual) {
        BitSet obits = new BitSet(orig.size());
        BitSet abits = new BitSet(actual.size());
        ArrayDeque<Diff<T>> stack = new ArrayDeque<Diff<T>>();
        ListIterator<T> it = actual.listIterator();
        block0: while (it.hasNext()) {
            T e = it.next();
            int i = obits.nextClearBit(0);
            while (i < orig.size()) {
                if (orig.get(i).equals(e)) {
                    obits.set(i);
                    abits.set(it.previousIndex());
                    stack.add(new Diff<T>(i, it.previousIndex(), e));
                    continue block0;
                }
                i = obits.nextClearBit(i + 1);
            }
        }
        ArrayList<Diff<T>> diffs = new ArrayList<Diff<T>>();
        int offset = 0;
        ListIterator<T> origIt = orig.listIterator();
        ListIterator<T> actualIt = actual.listIterator();
        while (origIt.hasNext() || actualIt.hasNext()) {
            int pos;
            T e;
            boolean removed = false;
            if (origIt.hasNext()) {
                e = origIt.next();
                pos = origIt.previousIndex();
                if (!obits.get(pos)) {
                    int apos = Math.max(0, pos - offset);
                    diffs.add(new Diff<T>(apos, -1, e));
                    removed = true;
                    ++offset;
                }
            }
            if (!actualIt.hasNext()) continue;
            e = actualIt.next();
            pos = actualIt.previousIndex();
            if (!abits.get(pos)) {
                diffs.add(new Diff<T>(-1, pos, e));
                if (!removed) continue;
                --offset;
                continue;
            }
            if (removed) continue;
            Diff moved = (Diff)stack.pop();
            int apos = Math.max(0, pos - offset);
            if (apos == moved.actual) continue;
            diffs.add(moved);
        }
        return diffs;
    }

    @FunctionalInterface
    public static interface Mapper<T, U> {
        public U apply(int var1, int var2, T var3);
    }
}

