/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class GenericType<T> {
    private static final Map<Class<?>, WeakReference<?>> CACHE = new HashMap();
    private final Type type;
    private final Class<?> rawType;

    public static <N> GenericType<N> create(Class<N> clazz) {
        return (GenericType)CACHE.compute(clazz, (p, r) -> {
            if (r == null || r.get() == null) {
                return new WeakReference(new GenericType(clazz, clazz));
            }
            return r;
        }).get();
    }

    private GenericType(Type type, Class<?> rawType) {
        this.type = type;
        this.rawType = rawType;
    }

    protected GenericType() throws IllegalArgumentException {
        this.type = GenericType.typeArgument(this.getClass(), GenericType.class);
        this.rawType = GenericType.rawClass(this.type);
    }

    public Type type() {
        return this.type;
    }

    public Class<?> rawType() {
        return this.rawType;
    }

    public T cast(Object object) throws ClassCastException {
        return (T)object;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GenericType) {
            return ((GenericType)obj).type.equals(this.type);
        }
        return false;
    }

    public String toString() {
        return this.type.toString();
    }

    private static Type typeArgument(Class<?> clazz, Class<?> baseClass) {
        ParameterizedType pt;
        Class rawType;
        int argIndex;
        Type currentType;
        Stack<Type> superclasses = new Stack<Type>();
        Class currentClass = clazz;
        do {
            currentType = currentClass.getGenericSuperclass();
            superclasses.push(currentType);
            if (currentType instanceof Class) {
                currentClass = (Class)currentType;
                continue;
            }
            if (!(currentType instanceof ParameterizedType)) continue;
            currentClass = (Class)((ParameterizedType)currentType).getRawType();
        } while (!currentClass.equals(Object.class) && !currentClass.equals(baseClass));
        TypeVariable tv = baseClass.getTypeParameters()[0];
        while (!superclasses.isEmpty() && (currentType = (Type)superclasses.pop()) instanceof ParameterizedType && (argIndex = Arrays.asList((rawType = (Class)(pt = (ParameterizedType)currentType).getRawType()).getTypeParameters()).indexOf(tv)) > -1) {
            Type typeArg = pt.getActualTypeArguments()[argIndex];
            if (typeArg instanceof TypeVariable) {
                tv = (TypeVariable)typeArg;
                continue;
            }
            return typeArg;
        }
        throw new IllegalArgumentException(String.format("%s does not specify the type parameter T of GenericType<T>", currentType));
    }

    private static Class<?> rawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() instanceof Class) {
                return (Class)parameterizedType.getRawType();
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type;
            Class<?> componentRawType = GenericType.rawClass(array.getGenericComponentType());
            return GenericType.getArrayClass(componentRawType);
        }
        throw new IllegalArgumentException(String.format("Type parameter %s  is not a class or parameterized type whose raw type is a class", type));
    }

    private static Class<?> getArrayClass(Class<?> c) {
        try {
            Object o = Array.newInstance(c, 0);
            return o.getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

