/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;

public class LazyValue<T>
implements Supplier<T> {
    private static final VarHandle LOCK;
    private static final VarHandle STATE;
    private T value;
    private Supplier<T> delegate;
    private volatile Semaphore lock;
    private volatile int state;

    public LazyValue(T value) {
        this.value = value;
        this.state = 2;
    }

    public LazyValue(Supplier<T> supplier) {
        this.delegate = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        int stateCopy = this.state;
        if (stateCopy == 2) {
            return this.value;
        }
        Semaphore lockCopy = this.lock;
        while (stateCopy != 2 && !STATE.compareAndSet(this, 0, 1)) {
            if (lockCopy == null) {
                LOCK.compareAndSet(this, null, new Semaphore(0));
                lockCopy = this.lock;
            }
            if ((stateCopy = this.state) != 1) continue;
            lockCopy.acquireUninterruptibly();
            stateCopy = this.state;
        }
        try {
            if (stateCopy == 2) {
                T t = this.value;
                return t;
            }
            stateCopy = 0;
            this.value = this.delegate.get();
            this.delegate = null;
            stateCopy = 2;
            this.state = 2;
        }
        finally {
            if (stateCopy == 0) {
                this.state = 0;
            }
            if ((lockCopy = this.lock) != null) {
                lockCopy.release();
            }
        }
        return this.value;
    }

    static {
        try {
            LOCK = MethodHandles.lookup().findVarHandle(LazyValue.class, "lock", Semaphore.class);
            STATE = MethodHandles.lookup().findVarHandle(LazyValue.class, "state", Integer.TYPE);
        }
        catch (Exception e) {
            throw new Error("Unable to obtain VarHandle's", e);
        }
    }
}

