/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.SourcePath;
import io.helidon.build.common.Strings;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PathFilters {
    private static final BiPredicate<Path, Path> ANY = (path, root) -> true;
    private static final BiPredicate<Path, Path> NONE = (path, root) -> false;
    private static final Path ROOT = Path.of(File.separator, new String[0]);
    private static final String SINGLE_CHAR_WILDCARD = "?";
    private static final String MULTI_CHAR_WILDCARD = "*";
    private static final char SINGLE_CHAR_WILDCARD_CHAR = '?';
    private static final char MULTI_CHAR_WILDCARD_CHAR = '*';
    private static final String DIRECTORY_WILDCARD = "**";
    private static final String PATH_SEPARATOR = "/";
    private static final char PATH_SEPARATOR_CHAR = '/';
    private static final char WINDOWS_SEPARATOR_CHAR = '\\';
    private static final String ANY_PARENT_WILDCARD_PATTERN = "**/";
    private static final String ANY_CHILD_WILDCARD_PATTERN = "/**";
    private static final String ANY_FILE_PATTERN = "**/*";
    private static final String ESCAPED_MULTI_CHAR_WILDCARD = "\\*";
    private static final char SINGLE_CHAR_WILDCARD_REGEX_CHAR = '.';
    private static final String MULTI_CHAR_WILDCARD_REGEX = ".*";
    private static final String SINGLE_CHAR_REGEX_WILDCARD = ".";
    private static final String ESCAPED_DOT_LITERAL = "\\.";

    public static BiPredicate<Path, Path> matchesAny() {
        return ANY;
    }

    public static BiPredicate<Path, Path> matchesNone() {
        return NONE;
    }

    public static BiPredicate<Path, Path> matchesFileName(String name) {
        return (path, root) -> path.getFileName().toString().endsWith(name);
    }

    public static BiPredicate<Path, Path> matchesFileNameSuffix(String suffix) {
        return (path, root) -> path.getFileName().toString().endsWith(suffix);
    }

    public static BiPredicate<Path, Path> matches(String pattern) {
        String patternPrefix;
        if ((pattern = PathFilters.normalizePattern(pattern)).equals(ANY_FILE_PATTERN)) {
            return PathFilters.matchesAny();
        }
        if (pattern.startsWith(ANY_PARENT_WILDCARD_PATTERN)) {
            String patternSuffix = PathFilters.stripConstantPrefix(pattern, ANY_PARENT_WILDCARD_PATTERN);
            if (patternSuffix.indexOf(47) < 0) {
                return PathFilters.toFileNamePredicate(patternSuffix);
            }
            if (patternSuffix.endsWith(ANY_CHILD_WILDCARD_PATTERN)) {
                String containedPath = PathFilters.stripConstantSuffix(patternSuffix, ANY_CHILD_WILDCARD_PATTERN);
                return (path, root) -> PathFilters.normalizePath(path, root).contains(containedPath);
            }
        } else if (pattern.endsWith(ANY_CHILD_WILDCARD_PATTERN) && !PathFilters.containsWildcardChar(patternPrefix = PathFilters.stripConstantSuffix(pattern, DIRECTORY_WILDCARD))) {
            return (path, root) -> PathFilters.normalizePath(path, root).startsWith(patternPrefix);
        }
        String[] patternSegments = SourcePath.parseSegments(pattern);
        return (path, root) -> {
            String[] pathSegments = SourcePath.parseSegments(PathFilters.normalizePath(path, root));
            return SourcePath.matches(pathSegments, patternSegments);
        };
    }

    public static BiPredicate<Path, Path> matchesAny(List<String> patterns) {
        if (patterns.isEmpty()) {
            return PathFilters.matchesAny();
        }
        if (patterns.size() == 1) {
            return PathFilters.matches(patterns.get(0));
        }
        List filters = patterns.stream().map(PathFilters::matches).collect(Collectors.toList());
        return (path, root) -> {
            Path relativePath = PathFilters.relativizePath(path, root);
            for (BiPredicate filter : filters) {
                if (!filter.test(relativePath, root)) continue;
                return true;
            }
            return false;
        };
    }

    public static BiPredicate<Path, Path> matchesNone(List<String> patterns) {
        if (patterns.isEmpty()) {
            return PathFilters.matchesAny();
        }
        BiPredicate<Path, Path> filter = PathFilters.matchesAny(patterns);
        return (path, root) -> !filter.test((Path)path, (Path)root);
    }

    public static BiPredicate<Path, Path> matches(List<String> includes, List<String> excludes) {
        if (includes.isEmpty()) {
            if (excludes.size() == 1 && excludes.get(0).equals(ANY_FILE_PATTERN)) {
                return PathFilters.matchesNone();
            }
            return PathFilters.matchesNone(excludes);
        }
        return PathFilters.matchesAny(includes).and(PathFilters.matchesNone(excludes));
    }

    private static BiPredicate<Path, Path> toFileNamePredicate(String fileNamePattern) {
        if (fileNamePattern.contains(SINGLE_CHAR_WILDCARD)) {
            return PathFilters.toFileNameRegexPredicate(fileNamePattern);
        }
        String[] segments = fileNamePattern.split(ESCAPED_MULTI_CHAR_WILDCARD);
        int segmentCount = segments.length;
        if (segmentCount == 1) {
            String fileName = segments[0];
            return PathFilters.matchesFileName(fileName);
        }
        if (segmentCount == 2) {
            String prefix = segments[0];
            String suffix = segments[1];
            if (prefix.isEmpty()) {
                return PathFilters.matchesFileNameSuffix(suffix);
            }
            return (path, root) -> {
                String name = path.getFileName().toString();
                return name.startsWith(prefix) && name.endsWith(suffix);
            };
        }
        return PathFilters.toFileNameRegexPredicate(fileNamePattern);
    }

    private static BiPredicate<Path, Path> toFileNameRegexPredicate(String fileNamePattern) {
        String regex = fileNamePattern.replace(SINGLE_CHAR_REGEX_WILDCARD, ESCAPED_DOT_LITERAL).replace('?', '.').replace(MULTI_CHAR_WILDCARD, MULTI_CHAR_WILDCARD_REGEX);
        Pattern pattern = Pattern.compile(regex);
        return (path, root) -> pattern.matcher(path.getFileName().toString()).matches();
    }

    private static boolean containsWildcardChar(String value) {
        return value.indexOf(63) >= 0 || value.indexOf(42) >= 0;
    }

    private static String stripConstantPrefix(String value, String constant) {
        return value.substring(constant.length());
    }

    private static String stripConstantSuffix(String value, String constant) {
        return value.substring(0, value.length() - constant.length());
    }

    private static boolean isAbsolute(Path path) {
        return path.isAbsolute() || ROOT.equals(path.getRoot());
    }

    private static Path relativizePath(Path path, Path root) {
        return PathFilters.isAbsolute(path) ? root.relativize(path) : path;
    }

    private static String normalizePath(Path path, Path root) {
        return PathFilters.normalizePathSeparators(PathFilters.relativizePath(path, root).toString());
    }

    private static String normalizePathSeparators(String path) {
        return path.replace('\\', '/');
    }

    private static String normalizePattern(String pattern) {
        if (Strings.isNotValid((String)pattern)) {
            throw new IllegalArgumentException("pattern cannot be null or empty");
        }
        if (((String)(pattern = PathFilters.normalizePathSeparators((String)pattern))).endsWith(PATH_SEPARATOR)) {
            pattern = (String)pattern + DIRECTORY_WILDCARD;
        }
        return pattern;
    }

    private PathFilters() {
    }
}

