/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.logging.Log;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathFinder {
    private static final String PATH_ENV_VAR = "PATH";
    private static final List<String> WINDOWS_EXECUTABLE_EXTENSIONS = List.of("exe", "bin", "bat", "cmd", "ps1");
    private static final boolean IS_WINDOWS = File.pathSeparatorChar != ':';
    private static final Predicate<Path> VALID_PATH = p -> Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0]);
    private static final List<Path> PATH_ENTRIES = Optional.ofNullable(System.getenv("PATH")).map(p -> Arrays.asList(p.split(File.pathSeparator))).stream().flatMap(Collection::stream).map(x$0 -> Path.of(x$0, new String[0])).filter(VALID_PATH).collect(Collectors.toList());

    private PathFinder() {
    }

    private static Stream<Path> entries(List<Optional<Path>> entries) {
        return entries.stream().flatMap(Optional::stream).filter(VALID_PATH);
    }

    private static Path findWindowsCmd(Path dir, String cmd) {
        return WINDOWS_EXECUTABLE_EXTENSIONS.stream().map(ext -> dir.resolve(cmd + "." + ext)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElse(null);
    }

    private static Path findCmd(Path dir, String cmd) {
        Log.debug("Searching for cmd: %s in %s", cmd, dir);
        Path cmdFile = dir.resolve(cmd);
        if (Files.isRegularFile(cmdFile, new LinkOption[0])) {
            return cmdFile;
        }
        return IS_WINDOWS ? PathFinder.findWindowsCmd(dir, cmd) : null;
    }

    public static Optional<Path> find(String fileName, List<Optional<Path>> overrides, List<Optional<Path>> extras) {
        return Stream.of(PathFinder.entries(overrides), PATH_ENTRIES.stream(), PathFinder.entries(extras)).flatMap(Function.identity()).flatMap(dir -> Optional.ofNullable(PathFinder.findCmd(dir, fileName)).stream()).findFirst();
    }
}

