/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;

public final class RingBuffer<E>
implements Iterable<E> {
    private final Queue<E> queue;
    private final int size;

    public RingBuffer(int size) {
        this.queue = new ArrayDeque(size);
        this.size = size;
    }

    public boolean add(E e) {
        if (this.queue.size() == this.size) {
            this.queue.poll();
        }
        return this.queue.add(e);
    }

    public int hashCode() {
        return this.queue.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RingBuffer that = (RingBuffer)o;
        return this.size == that.size && Objects.equals(this.queue, that.queue);
    }

    public String toString() {
        return this.queue.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }
}

