/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import io.helidon.build.common.Strings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SourcePath {
    private static final char WILDCARD_CHAR = '*';
    private static final String WILDCARD = "*";
    private static final String DOUBLE_WILDCARD = "**";
    private static final List<String> DEFAULT_INCLUDES = List.of("**/*");
    private final String[] segments;
    private static final Comparator<SourcePath> COMPARATOR = new SourceFileComparator();

    public SourcePath(File dir, File file) {
        this(dir.toPath(), file.toPath());
    }

    public SourcePath(Path dir, Path file) {
        this(dir.relativize(file));
    }

    public SourcePath(Path path) {
        this(Strings.normalizePath(path));
    }

    public SourcePath(String path) {
        this.segments = SourcePath.parseSegments(path);
    }

    public SourcePath(String prefix, String path) {
        this(prefix != null ? List.of(prefix, path) : List.of(path));
    }

    public SourcePath(List<String> paths) {
        this.segments = (String[])paths.stream().flatMap(p -> Arrays.stream(SourcePath.parseSegments(p))).toArray(String[]::new);
    }

    public static String[] parseSegments(String path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        String[] tokens = path.split("/");
        ArrayList<String> segments = new ArrayList<String>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i < tokens.length - 1 && token.isEmpty() || token.equals(".")) continue;
            segments.add(token);
        }
        return segments.toArray(new String[0]);
    }

    public static List<SourcePath> filter(Collection<SourcePath> paths, Collection<String> includesPatterns, Collection<String> excludesPatterns) {
        if (paths == null || paths.isEmpty()) {
            return Collections.emptyList();
        }
        return paths.stream().filter(p -> p.matches(includesPatterns, excludesPatterns)).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourcePath other = (SourcePath)obj;
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i].equals(other.segments[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.segments);
        return hash;
    }

    private static boolean doRecursiveMatch(String[] segments, int offset, String[] patterns, int pOffset) {
        String pattern;
        boolean expand = false;
        while (pOffset < patterns.length && offset != segments.length) {
            pattern = patterns[pOffset];
            if (pattern.equals(DOUBLE_WILDCARD)) {
                expand = true;
            } else {
                if (expand) {
                    for (int j = 0; j < segments.length; ++j) {
                        if (!SourcePath.wildcardMatch(segments[j], pattern) || !SourcePath.doRecursiveMatch(segments, j + 1, patterns, pOffset + 1)) continue;
                        return true;
                    }
                    return false;
                }
                if (!SourcePath.wildcardMatch(segments[offset], pattern)) {
                    return false;
                }
                ++offset;
            }
            ++pOffset;
        }
        while (pOffset < patterns.length) {
            pattern = patterns[pOffset];
            if (!pattern.equals(DOUBLE_WILDCARD) && !pattern.equals(WILDCARD)) {
                return false;
            }
            ++pOffset;
        }
        return true;
    }

    public boolean matches(Collection<String> includesPatterns, Collection<String> excludesPatterns) {
        if (includesPatterns == null || includesPatterns.isEmpty()) {
            includesPatterns = DEFAULT_INCLUDES;
        }
        return this.matches(includesPatterns) && !this.matches(excludesPatterns);
    }

    public boolean matches(Collection<String> patterns) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!this.matches(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(String pattern) {
        if (pattern == null) {
            return false;
        }
        if (pattern.isEmpty()) {
            return this.segments.length == 0;
        }
        return SourcePath.doRecursiveMatch(this.segments, 0, SourcePath.parseSegments(pattern), 0);
    }

    public static boolean matches(String[] path, String[] pattern) {
        Objects.requireNonNull(path);
        if (pattern == null) {
            return false;
        }
        if (pattern.length == 0) {
            return path.length == 0;
        }
        return SourcePath.doRecursiveMatch(path, 0, pattern, 0);
    }

    public static boolean wildcardMatch(String val, String pattern) {
        boolean matched;
        block7: {
            String subSegment;
            String subPattern;
            block8: {
                int wildcardIdx;
                Objects.requireNonNull(val);
                Objects.requireNonNull(pattern);
                if (pattern.isEmpty()) {
                    return val.isEmpty();
                }
                int valIdx = 0;
                int patternIdx = 0;
                matched = true;
                while ((wildcardIdx = pattern.indexOf(42, patternIdx)) >= 0) {
                    int patternOffset = wildcardIdx - patternIdx;
                    if (patternOffset > 0) {
                        String subPattern2 = pattern.substring(patternIdx, wildcardIdx);
                        int idx = val.indexOf(subPattern2, valIdx);
                        if (patternIdx > 0 && pattern.charAt(patternIdx - 1) == '*') {
                            if (idx < valIdx) {
                                matched = false;
                                break block7;
                            }
                        } else if (idx != valIdx) {
                            matched = false;
                            break block7;
                        }
                        valIdx = idx + subPattern2.length();
                    }
                    patternIdx = wildcardIdx + 1;
                }
                subPattern = pattern.substring(patternIdx);
                subSegment = val.substring(valIdx);
                if (patternIdx <= 0 || pattern.charAt(patternIdx - 1) != '*') break block8;
                if (subSegment.endsWith(subPattern)) break block7;
                matched = false;
                break block7;
            }
            if (subSegment.equals(subPattern)) break block7;
            matched = false;
        }
        return matched;
    }

    public String asString() {
        return this.asString(true);
    }

    public String asString(boolean absolute) {
        StringBuilder sb = new StringBuilder(absolute ? "/" : "");
        for (int i = 0; i < this.segments.length; ++i) {
            sb.append(this.segments[i]);
            if (i >= this.segments.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public String toString() {
        return this.asString(false);
    }

    public static List<SourcePath> sort(List<SourcePath> sourcePaths) {
        Objects.requireNonNull(sourcePaths, "sourcePaths");
        sourcePaths.sort(COMPARATOR);
        return sourcePaths;
    }

    public static List<SourcePath> scan(File dir) {
        return SourcePath.scan(dir.toPath());
    }

    public static List<SourcePath> scan(Path dir) {
        return SourcePath.doScan(dir, dir);
    }

    private static List<SourcePath> doScan(Path root, Path dir) {
        List<SourcePath> list;
        block11: {
            if (!Files.exists(dir, new LinkOption[0])) {
                return List.of();
            }
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);
            try {
                ArrayList<SourcePath> sourcePaths = new ArrayList<SourcePath>();
                for (Path next : dirStream) {
                    if (Files.isDirectory(next, new LinkOption[0])) {
                        sourcePaths.addAll(SourcePath.doScan(root, next));
                        continue;
                    }
                    sourcePaths.add(new SourcePath(root, next));
                }
                list = SourcePath.sort(sourcePaths);
                if (dirStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            dirStream.close();
        }
        return list;
    }

    private static class SourceFileComparator
    implements Comparator<SourcePath> {
        private SourceFileComparator() {
        }

        @Override
        public int compare(SourcePath o1, SourcePath o2) {
            for (int i = 0; i < o1.segments.length; ++i) {
                int cmp = o1.segments[i].compareTo(o2.segments[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

