/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Unchecked {
    public static <T, E extends Exception> Supplier<T> unchecked(CheckedSupplier<T, E> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <E extends Exception> Runnable unchecked(CheckedRunnable<E> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> unchecked(CheckedConsumer<T, E> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> unchecked(CheckedBiConsumer<T, U, E> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static <T, U, E extends Exception> Function<T, U> unchecked(CheckedFunction<T, U, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new UncheckedException(ex);
            }
        };
    }

    public static RuntimeException wrap(Throwable ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new UncheckedException(ex);
    }

    public static Throwable unwrap(Throwable ex) {
        if (ex instanceof UncheckedException) {
            return ex.getCause();
        }
        return ex;
    }

    public static interface CheckedSupplier<T, E extends Exception> {
        public T get() throws E;
    }

    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }

    public static interface CheckedConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    public static interface CheckedBiConsumer<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    public static interface CheckedFunction<T, U, E extends Exception> {
        public U apply(T var1) throws E;
    }

    public static class UncheckedException
    extends RuntimeException {
        public UncheckedException(Throwable cause) {
            super(cause);
        }
    }
}

