/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.logging;

import io.helidon.build.common.PrintStreams;
import io.helidon.build.common.logging.LogFormatter;
import io.helidon.build.common.logging.LogLevel;
import io.helidon.build.common.logging.LogWriter;
import java.io.PrintStream;

public final class SystemLogWriter
extends LogWriter {
    public static final SystemLogWriter INSTANCE = new SystemLogWriter();
    private final PrintStream stdErr;
    private final PrintStream stdOut = PrintStreams.autoFlush(PrintStreams.STDOUT);

    private SystemLogWriter() {
        this.stdErr = PrintStreams.autoFlush(PrintStreams.STDERR);
    }

    @Override
    public void writeEntry(LogLevel level, Throwable thrown, String message, Object ... args) {
        if (level.ordinal() >= LogLevel.get().ordinal()) {
            String entry = LogFormatter.format(level, thrown, message, args);
            this.recordEntry(entry);
            switch (level) {
                case DEBUG: 
                case VERBOSE: 
                case INFO: {
                    this.stdOut.println(entry);
                    break;
                }
                case WARN: 
                case ERROR: {
                    this.stdErr.println(entry);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }
}

