/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.licensing;

import io.helidon.build.licensing.model.AttributionDependency;
import io.helidon.build.licensing.model.AttributionDocument;
import io.helidon.build.licensing.model.AttributionLicense;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class Report {
    static final String HEADER_80 = "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=";
    static final String APACHE_ID = "Apache-2.0";
    static final String EPL1_ID = "EPL-1.0";
    static final String EPL2_ID = "EPL-2.0";
    static final String LGPL2_1_ID = "LGPL-2.1-only";
    static final String MPL2_ID = "MPL-2.0";
    static final String[] LICENSES = new String[]{"Apache-2.0", "EPL-1.0", "EPL-2.0", "MPL-2.0", "LGPL-2.1-only"};
    public static final String INPUT_FILE_DIR_PROPERTY_NAME = "inputFileDir";
    public static final String INPUT_FILE_NAME_PROPERTY_NAME = "inputFileName";
    public static final String OUTPUT_FILE_DIR_PROPERTY_NAME = "outputFileDir";
    public static final String OUTPUT_FILE_NAME_PROPERTY_NAME = "outputFileName";
    public static final String MODULES_PROPERTY_NAME = "modules";
    public static final String DEFAULT_INPUT_FILE_NAME = "HELIDON_THIRD_PARTY_LICENSES.xml";
    public static final String DEFAULT_INPUT_FILE_DIR = "";
    public static final String DEFAULT_OUTPUT_FILE_NAME = "HELIDON_THIRD_PARTY_LICENSES.txt";
    public static final String DEFAULT_OUTPUT_FILE_DIR = ".";
    public static final String DEFAULT_MODULES_LIST = "*";
    private String inputFileDir;
    private String inputFileName;
    private String outputFileDir;
    private String outputFileName;
    private Set<String> moduleList;
    private Consumer<String> outputHandler;

    private Report() {
    }

    private Report(Builder builder) {
        this.inputFileDir = builder.inputFileDir();
        this.inputFileName = builder.inputFileName();
        this.outputFileDir = builder.outputFileDir();
        this.outputFileName = builder.outputFileName();
        this.moduleList = builder.moduleList();
        this.outputHandler = builder.outputHandler();
    }

    public static void main(String[] args) throws IOException, JAXBException {
        Report.builder().moduleList(System.getProperty(MODULES_PROPERTY_NAME, DEFAULT_MODULES_LIST)).inputFileDir(System.getProperty(INPUT_FILE_DIR_PROPERTY_NAME, DEFAULT_INPUT_FILE_DIR)).inputFileName(System.getProperty(INPUT_FILE_NAME_PROPERTY_NAME, DEFAULT_INPUT_FILE_NAME)).outputFileDir(System.getProperty(OUTPUT_FILE_DIR_PROPERTY_NAME, DEFAULT_OUTPUT_FILE_DIR)).outputFileName(System.getProperty(OUTPUT_FILE_NAME_PROPERTY_NAME, DEFAULT_OUTPUT_FILE_NAME)).build().execute();
    }

    static String convertToArtifactId(String s) {
        String name = Paths.get(s, new String[0]).getFileName().toString();
        if (name.endsWith(".jar")) {
            int n = name.lastIndexOf(45);
            if (n < 0) {
                n = name.lastIndexOf(46);
            }
            return name.substring(0, n);
        }
        return name;
    }

    public void execute() throws IOException, JAXBException {
        if (!new File(this.outputFileDir).exists()) {
            String s = String.format("Can't create output file %s. Directory %s does not exist.", this.outputFileName, this.outputFileDir);
            throw new IOException(s);
        }
        File outputFile = new File(this.outputFileDir, this.outputFileName);
        File inputFile = null;
        if (this.inputFileDir != null && !this.inputFileDir.isEmpty()) {
            inputFile = new File(this.inputFileDir, this.inputFileName);
        }
        try (FileWriter w = new FileWriter(outputFile);){
            this.info("Reading input from " + (String)(inputFile != null ? inputFile.getCanonicalPath() : this.inputFileName + " on classpath"));
            this.info("Writing output to " + outputFile.getCanonicalPath());
            AttributionDocument document = inputFile != null ? this.loadAttributionDocument(inputFile) : this.loadAttributionDocumentFromClasspath("META-INF/" + this.inputFileName);
            if (this.generateAttributionFile(document, w)) {
                w.flush();
            }
        }
        catch (IOException e) {
            String s = "Error writing file " + outputFile.getPath();
            throw new IOException(s, e);
        }
        catch (JAXBException e) {
            String s = "JAXB error creating file " + outputFile.getPath();
            throw new JAXBException(s, (Throwable)e);
        }
    }

    private AttributionDocument loadAttributionDocument(File file) throws IOException, JAXBException {
        if (file != null) {
            if (!file.canRead()) {
                String s = String.format("Can't read input file %s.", file.getCanonicalPath());
                throw new IOException(s);
            }
            try {
                FileInputStream fis = new FileInputStream(file);
                AttributionDocument attributionDocument = this.loadAttributionDocumentFromStream(fis);
                fis.close();
                return attributionDocument;
            }
            catch (JAXBException e) {
                String s = String.format("Can't load input file %s.", file);
                throw new JAXBException(s, (Throwable)e);
            }
        }
        return null;
    }

    private AttributionDocument loadAttributionDocumentFromClasspath(String name) throws JAXBException, IOException {
        InputStream is = Report.class.getClassLoader().getResourceAsStream(name);
        if (is == null) {
            throw new IOException("Can't get resource " + name);
        }
        return this.loadAttributionDocumentFromStream(is);
    }

    private AttributionDocument loadAttributionDocumentFromStream(InputStream is) throws JAXBException {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{AttributionDocument.class});
        Unmarshaller unmarshaller = contextObj.createUnmarshaller();
        return (AttributionDocument)unmarshaller.unmarshal(is);
    }

    private boolean generateAttributionFile(AttributionDocument attributionDocument, FileWriter w) throws IOException {
        boolean first = true;
        List<AttributionDependency> deps = attributionDocument.getDependencies();
        HashSet<String> licensesUsed = new HashSet<String>();
        for (AttributionDependency d : deps) {
            HashSet<String> intersection = new HashSet<String>(this.moduleList);
            intersection.retainAll(d.getConsumers());
            if (!this.moduleList.isEmpty() && intersection.isEmpty()) continue;
            if (first) {
                this.appendResourceToFile("NOTICE_HEADER.txt", w);
                first = false;
            }
            w.write("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n");
            w.write(d.getName() + " " + d.getVersion() + " " + d.getLicensor() + "\n");
            String lic = d.getLicenseName();
            if (lic != null && !lic.isEmpty()) {
                w.write(lic + "\n");
            }
            w.write("Used by: " + d.getConsumers() + "\n");
            w.write("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n");
            w.write(d.getAttribution());
            w.write("\n");
            this.detectLicenses(licensesUsed, d.getAttribution());
        }
        if (first) {
            return false;
        }
        first = true;
        for (String s : licensesUsed) {
            if (first) {
                this.appendResourceToFile("LICENSE_HEADER.txt", w);
                first = false;
            }
            w.write(s + "\n");
            AttributionLicense license = this.getLicense(attributionDocument, s);
            if (license != null) {
                w.write(license.getText());
            } else {
                w.write("No license text found for " + s);
            }
            w.write("=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n");
        }
        return true;
    }

    private AttributionLicense getLicense(AttributionDocument attributionDocument, String licenseName) {
        List<AttributionLicense> licenses = attributionDocument.getLicenses();
        for (AttributionLicense l : licenses) {
            if (!licenseName.equals(l.getName())) continue;
            return l;
        }
        return null;
    }

    void detectLicenses(Set<String> licenseSet, String attribution) {
        for (String s : LICENSES) {
            if (!attribution.contains(s)) continue;
            licenseSet.add(s);
        }
    }

    private void appendResourceToFile(String resourceName, FileWriter writer) throws IOException {
        int n;
        InputStream is = Report.class.getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new IOException("Could not get InputStream from resource " + resourceName);
        }
        InputStreamReader reader = new InputStreamReader(is);
        char[] buffer = new char[256];
        do {
            if ((n = reader.read(buffer)) <= 0) continue;
            writer.write(buffer, 0, n);
        } while (n > 0);
    }

    private void info(String s) {
        if (this.outputHandler != null) {
            this.outputHandler.accept(s);
        } else {
            System.out.println(s);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String inputFileDir = "";
        private String inputFileName = "HELIDON_THIRD_PARTY_LICENSES.xml";
        private String outputFileDir = ".";
        private String outputFileName = "HELIDON_THIRD_PARTY_LICENSES.txt";
        private Set<String> moduleList = Collections.emptySet();
        private Consumer<String> outputHandler = s -> System.out.println((String)s);

        private Builder() {
        }

        public String inputFileDir() {
            return this.inputFileDir;
        }

        public Builder inputFileDir(String inputFileDir) {
            this.inputFileDir = inputFileDir;
            return this;
        }

        public String inputFileName() {
            return this.inputFileName;
        }

        public Builder inputFileName(String inputFileName) {
            this.inputFileName = inputFileName;
            return this;
        }

        public String outputFileDir() {
            return this.outputFileDir;
        }

        public Builder outputFileDir(String outputFileDir) {
            this.outputFileDir = outputFileDir;
            return this;
        }

        public String outputFileName() {
            return this.outputFileName;
        }

        public Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        public Set<String> moduleList() {
            return this.moduleList;
        }

        public Builder moduleList(Set<String> moduleList) {
            this.moduleList = moduleList;
            return this;
        }

        public Builder moduleList(String moduleList) {
            if (moduleList == null || moduleList.isEmpty() || moduleList.equals(Report.DEFAULT_MODULES_LIST)) {
                this.moduleList(Collections.emptySet());
            } else {
                List<String> tmpList = Arrays.asList(moduleList.split(","));
                this.moduleList(tmpList.stream().map(Report::convertToArtifactId).collect(Collectors.toSet()));
            }
            return this;
        }

        public Consumer<String> outputHandler() {
            return this.outputHandler;
        }

        public Builder outputHandler(Consumer<String> outputHandler) {
            this.outputHandler = outputHandler;
            return this;
        }

        public Report build() {
            return new Report(this);
        }
    }
}

