/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.Scanner;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="native-image", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true)
public class GraalNativeMojo
extends AbstractMojo {
    private static final String NATIVE_IMAGE_CMD = "native-image";
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDirectory;
    @Parameter(defaultValue="${env.GRAALVM_HOME}")
    private File graalVMHome;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true, required=true)
    private String finalName;
    @Parameter(defaultValue="true", property="native.image.reportExceptionStackTraces")
    private boolean reportExceptionStackTraces;
    @Parameter(defaultValue="true", property="native.image.noServer")
    private boolean noServer;
    @Parameter(defaultValue="true")
    private boolean addProjectResources;
    @Parameter
    private List<String> includeResources;
    @Parameter(defaultValue="false", property="native.image.buildShared")
    private boolean buildShared;
    @Parameter(defaultValue="false", property="native.image.buildStatic")
    private boolean buildStatic;
    @Parameter
    private List<String> additionalArgs;
    @Parameter(defaultValue="false", property="native.image.skip")
    private boolean skipNativeImage;
    private Process process;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipNativeImage) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        File artifact = this.project.getArtifact().getFile();
        if (artifact == null) {
            artifact = new File(this.buildDirectory, this.project.getBuild().getFinalName() + ".jar");
        }
        if (!artifact.exists()) {
            throw new MojoFailureException("Artifact does not exist: " + artifact.getAbsolutePath());
        }
        File outputFile = new File(this.buildDirectory, this.finalName);
        this.getLog().info((CharSequence)("Building native image :" + outputFile.getAbsolutePath()));
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.findNativeImageCmd().getAbsolutePath());
        if (this.buildShared || this.buildStatic) {
            if (this.buildShared && this.buildShared) {
                throw new MojoExecutionException("static and shared option cannot be used together");
            }
            if (this.buildShared) {
                this.getLog().info((CharSequence)"Building a shared library");
                command.add("--shared");
            }
            if (this.buildStatic) {
                this.getLog().info((CharSequence)"Building a statically linked executable");
                command.add("--static");
            }
        }
        command.add("-H:Name=" + outputFile.getAbsolutePath());
        String resources = this.getResources();
        if (!resources.isEmpty()) {
            command.add("-H:IncludeResources=" + resources);
        }
        if (this.reportExceptionStackTraces) {
            command.add("-H:+ReportExceptionStackTraces");
        }
        if (this.noServer) {
            command.add("--no-server");
        }
        command.add("-classpath");
        command.add(this.getClasspath());
        if (this.additionalArgs != null) {
            command.addAll(this.additionalArgs);
        }
        command.add("-jar");
        command.add(artifact.getAbsolutePath());
        this.getLog().debug((CharSequence)("Executing command: " + command));
        ProcessBuilder pb = new ProcessBuilder(command.toArray(new String[0]));
        pb.directory(this.buildDirectory);
        Thread stdoutReader = new Thread(this::logStdout);
        Thread stderrReader = new Thread(this::logStderr);
        try {
            this.process = pb.start();
            stdoutReader.start();
            stderrReader.start();
            int exitCode = this.process.waitFor();
            stdoutReader.join();
            stderrReader.join();
            if (exitCode != 0) {
                throw new MojoFailureException("Image generation failed, exit code: " + exitCode);
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("Image generation error", ex);
        }
    }

    private void logStdout() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        try {
            String line = reader.readLine();
            while (line != null) {
                this.getLog().info((CharSequence)line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void logStderr() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        try {
            String line = reader.readLine();
            while (line != null) {
                this.getLog().warn((CharSequence)line);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getResources() {
        this.getLog().debug((CharSequence)"Building resources string");
        ArrayList<String> resources = new ArrayList<String>();
        if (this.addProjectResources) {
            this.getLog().debug((CharSequence)"Scanning project resources");
            for (Resource resource : this.project.getResources()) {
                File resourcesDir = new File(resource.getDirectory());
                Scanner scanner = this.buildContext.newScanner(resourcesDir);
                String[] includes = null;
                if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                    includes = resource.getIncludes().toArray(new String[resource.getIncludes().size()]);
                }
                scanner.setIncludes(includes);
                String[] excludes = null;
                if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                    excludes = resource.getExcludes().toArray(new String[resource.getExcludes().size()]);
                }
                scanner.setExcludes(excludes);
                scanner.scan();
                for (String included : scanner.getIncludedFiles()) {
                    this.getLog().debug((CharSequence)("Found resource: " + included));
                    resources.add(included);
                }
            }
        }
        if (this.includeResources != null) {
            this.getLog().debug((CharSequence)("Adding provided resources: " + this.includeResources));
            resources.addAll(this.includeResources);
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append("|");
        }
        String resourcesStr = sb.toString();
        this.getLog().debug((CharSequence)("Built resources string: " + resourcesStr));
        return resourcesStr;
    }

    private String getClasspath() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Building class-path string");
        try {
            StringBuilder sb = new StringBuilder();
            Iterator it = this.project.getRuntimeClasspathElements().iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(":");
            }
            String classpath = sb.toString();
            this.getLog().debug((CharSequence)("Built class-path: " + classpath));
            return classpath;
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Unable to get compile class-path", (Exception)((Object)ex));
        }
    }

    private File findNativeImageCmd() throws MojoExecutionException {
        if (this.graalVMHome == null || !this.graalVMHome.exists() || !this.graalVMHome.isDirectory()) {
            this.getLog().debug((CharSequence)"graalvm.home not set,looking in the PATH environment");
            String sysPath = System.getenv("PATH");
            if (sysPath == null || sysPath.isEmpty()) {
                throw new MojoExecutionException("PATH environment variable is unset or empty");
            }
            for (String p : sysPath.split(File.pathSeparator)) {
                File e = new File(p, NATIVE_IMAGE_CMD);
                if (!e.isFile()) continue;
                return e.getAbsoluteFile();
            }
            throw new MojoExecutionException("native-image not found in the PATH environment");
        }
        this.getLog().debug((CharSequence)"graalvm.home set, looking for bin/native-image");
        File binDir = new File(this.graalVMHome, "bin");
        if (!binDir.exists() || !binDir.isDirectory()) {
            throw new MojoExecutionException("Unable to find native-image command path, " + binDir.getAbsolutePath() + " is not a valid directory");
        }
        File cmd = new File(binDir, NATIVE_IMAGE_CMD);
        if (!cmd.exists() || !cmd.isFile()) {
            throw new MojoExecutionException("Unable to find native-image command path, " + cmd.getAbsolutePath() + " is not a valid file");
        }
        this.getLog().debug((CharSequence)("Found native-image: " + cmd));
        return cmd;
    }
}

