/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.maven;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="root-dir", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class RootDirMojo
extends AbstractMojo {
    private static final String CONTEXT_KEY = "io.helidon.build.maven.RootDirMojo.RootDir";
    private static final String PROPERTY_NAME = "top.parent.basedir";
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;

    public synchronized void execute() throws MojoFailureException {
        String rootDir = (String)this.getPluginContext().get(CONTEXT_KEY);
        if (null == rootDir) {
            rootDir = this.findRootDir();
            this.getPluginContext().put(CONTEXT_KEY, rootDir);
        }
        this.project.getProperties().setProperty(PROPERTY_NAME, rootDir);
        if (this.getLog().isDebugEnabled()) {
            StringWriter str = new StringWriter();
            this.project.getProperties().list(new PrintWriter(str));
            this.getLog().debug((CharSequence)("All project properties:\n\n" + str));
        }
        this.getLog().info((CharSequence)("Root directory configured to " + rootDir));
    }

    private String findRootDir() throws MojoFailureException {
        Path currentTopLevel = null;
        HashMap<Integer, Set> levelToPaths = new HashMap<Integer, Set>();
        Collection<MavenProject> mavenProjects = this.gatherWholeReactor();
        for (MavenProject current : mavenProjects) {
            if (current.getBasedir() == null) {
                this.getLog().info((CharSequence)("Basedir of " + current.getName() + " is null"));
                continue;
            }
            Path basedir = current.getBasedir().toPath().toAbsolutePath().normalize();
            if (currentTopLevel == null) {
                currentTopLevel = basedir;
                continue;
            }
            if (basedir.getNameCount() >= currentTopLevel.getNameCount()) continue;
            currentTopLevel = basedir;
            levelToPaths.computeIfAbsent(basedir.getNameCount(), it -> new HashSet()).add(basedir);
        }
        if (null == currentTopLevel) {
            throw new MojoFailureException("Failed to identify root path for module: " + this.project.getName());
        }
        Set sameLevel = (Set)levelToPaths.get(currentTopLevel.getNameCount());
        if (sameLevel.size() > 1) {
            throw new MojoFailureException("There is more than one root of your reactor: " + sameLevel);
        }
        return currentTopLevel.toString();
    }

    private Collection<MavenProject> gatherWholeReactor() {
        Set<MavenProject> toProcess = Collections.newSetFromMap(new IdentityHashMap());
        for (MavenProject reactorProject : this.reactorProjects) {
            toProcess.add(reactorProject);
            for (MavenProject parent = reactorProject.getParent(); parent != null; parent = parent.getParent()) {
                toProcess.add(parent);
            }
        }
        this.getLog().info((CharSequence)("Processing " + toProcess.size() + " project to find root"));
        return toProcess;
    }
}

