/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.OptionalHelper;
import io.helidon.common.configurable.ResourceImpl;
import io.helidon.common.configurable.ResourceUtil;
import io.helidon.config.Config;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public interface Resource {
    public static Resource create(URI uri) {
        return ResourceUtil.from(ResourceUtil.toIs(uri), uri.toString(), Source.URL);
    }

    public static Resource create(URI uri, Proxy proxy) {
        return ResourceUtil.from(ResourceUtil.toIs(uri, proxy), uri.toString(), Source.URL);
    }

    public static Resource create(String resourcePath) {
        return ResourceUtil.from(ResourceUtil.toIs(resourcePath), resourcePath, Source.CLASSPATH);
    }

    public static Resource create(Path fsPath) {
        return ResourceUtil.from(ResourceUtil.toIs(fsPath), fsPath.toAbsolutePath().toString(), Source.FILE);
    }

    public static Resource create(String description, byte[] bytes) {
        Objects.requireNonNull(bytes, "Resource bytes must not be null");
        return new ResourceImpl(Source.BINARY_CONTENT, description, bytes);
    }

    public static Resource create(String description, String string) {
        Objects.requireNonNull(string, "Resource content must not be null");
        return new ResourceImpl(Source.CONTENT, description, string.getBytes(StandardCharsets.UTF_8));
    }

    public static Resource create(String description, InputStream inputStream) {
        return ResourceUtil.from(inputStream, description, Source.UNKNOWN);
    }

    public static Optional<Resource> create(Config config, String keyPrefix) {
        return OptionalHelper.from(ResourceUtil.fromConfigPath(config, keyPrefix)).or(() -> ResourceUtil.fromConfigResourcePath(config, keyPrefix)).or(() -> ResourceUtil.fromConfigUrl(config, keyPrefix)).or(() -> ResourceUtil.fromConfigContent(config, keyPrefix)).or(() -> ResourceUtil.fromConfigB64Content(config, keyPrefix)).asOptional();
    }

    public InputStream stream();

    public byte[] bytes();

    public String string();

    public String string(Charset var1);

    public Source sourceType();

    public String location();

    public void cacheBytes();

    public static enum Source {
        FILE,
        CLASSPATH,
        URL,
        CONTENT,
        BINARY_CONTENT,
        UNKNOWN;

    }
}

