/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.configurable.ThreadPoolSupplier;
import io.helidon.config.Config;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public final class ServerThreadPoolSupplier
implements Supplier<ExecutorService> {
    private static final int MINIMUM_CORES = 2;
    private static final int DEFAULT_THREADS_PER_CORE = 8;
    private static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    private final ThreadPoolSupplier supplier;

    private ServerThreadPoolSupplier(ThreadPoolSupplier.Builder builder) {
        this.supplier = builder.build();
    }

    @Override
    public ExecutorService get() {
        return this.supplier.get();
    }

    public static ThreadPoolSupplier.Builder builder() {
        int cores = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        int corePoolSize = cores * 8;
        return ThreadPoolSupplier.builder().corePoolSize(corePoolSize).maxPoolSize(corePoolSize).queueCapacity(Integer.MAX_VALUE);
    }

    public static ThreadPoolSupplier create() {
        return ServerThreadPoolSupplier.builder().build();
    }

    public static ThreadPoolSupplier create(Config config) {
        return ServerThreadPoolSupplier.builder().config(config).build();
    }
}

